// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.paginators

import aws.sdk.kotlin.services.appflow.AppflowClient
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorProfilesRequest
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorProfilesResponse
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorsRequest
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorsResponse
import aws.sdk.kotlin.services.appflow.model.DescribeFlowExecutionRecordsRequest
import aws.sdk.kotlin.services.appflow.model.DescribeFlowExecutionRecordsResponse
import aws.sdk.kotlin.services.appflow.model.ListConnectorsRequest
import aws.sdk.kotlin.services.appflow.model.ListConnectorsResponse
import aws.sdk.kotlin.services.appflow.model.ListFlowsRequest
import aws.sdk.kotlin.services.appflow.model.ListFlowsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeConnectorProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeConnectorProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeConnectorProfilesResponse]
 */
public fun AppflowClient.describeConnectorProfilesPaginated(initialRequest: DescribeConnectorProfilesRequest = DescribeConnectorProfilesRequest { }): Flow<DescribeConnectorProfilesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeConnectorProfilesPaginated.describeConnectorProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeConnectorProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeConnectorProfilesResponse]
 */
public fun AppflowClient.describeConnectorProfilesPaginated(block: DescribeConnectorProfilesRequest.Builder.() -> Unit): Flow<DescribeConnectorProfilesResponse> =
    describeConnectorProfilesPaginated(DescribeConnectorProfilesRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeConnectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeConnectorsResponse]
 */
public fun AppflowClient.describeConnectorsPaginated(initialRequest: DescribeConnectorsRequest = DescribeConnectorsRequest { }): Flow<DescribeConnectorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeConnectorsPaginated.describeConnectors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeConnectorsResponse]
 */
public fun AppflowClient.describeConnectorsPaginated(block: DescribeConnectorsRequest.Builder.() -> Unit): Flow<DescribeConnectorsResponse> =
    describeConnectorsPaginated(DescribeConnectorsRequest.Builder().apply(block).build())

/**
 * Paginate over [DescribeFlowExecutionRecordsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeFlowExecutionRecordsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFlowExecutionRecordsResponse]
 */
public fun AppflowClient.describeFlowExecutionRecordsPaginated(initialRequest: DescribeFlowExecutionRecordsRequest): Flow<DescribeFlowExecutionRecordsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeFlowExecutionRecordsPaginated.describeFlowExecutionRecords(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeFlowExecutionRecordsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeFlowExecutionRecordsResponse]
 */
public fun AppflowClient.describeFlowExecutionRecordsPaginated(block: DescribeFlowExecutionRecordsRequest.Builder.() -> Unit): Flow<DescribeFlowExecutionRecordsResponse> =
    describeFlowExecutionRecordsPaginated(DescribeFlowExecutionRecordsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListConnectorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectorsResponse]
 */
public fun AppflowClient.listConnectorsPaginated(initialRequest: ListConnectorsRequest = ListConnectorsRequest { }): Flow<ListConnectorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listConnectorsPaginated.listConnectors(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListConnectorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListConnectorsResponse]
 */
public fun AppflowClient.listConnectorsPaginated(block: ListConnectorsRequest.Builder.() -> Unit): Flow<ListConnectorsResponse> =
    listConnectorsPaginated(ListConnectorsRequest.Builder().apply(block).build())

/**
 * Paginate over [ListFlowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListFlowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFlowsResponse]
 */
public fun AppflowClient.listFlowsPaginated(initialRequest: ListFlowsRequest = ListFlowsRequest { }): Flow<ListFlowsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listFlowsPaginated.listFlows(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListFlowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListFlowsResponse]
 */
public fun AppflowClient.listFlowsPaginated(block: ListFlowsRequest.Builder.() -> Unit): Flow<ListFlowsResponse> =
    listFlowsPaginated(ListFlowsRequest.Builder().apply(block).build())
