// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateConnectorRegistrationRequest private constructor(builder: Builder) {
    /**
     * The `clientToken` parameter is an idempotency token. It ensures that your `UpdateConnectorRegistration` request completes only once. You choose the value to pass. For example, if you don't receive a response from your request, you can safely retry the request with the same `clientToken` parameter value.
     *
     * If you omit a `clientToken` value, the Amazon Web Services SDK that you are using inserts a value for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own value for other use cases.
     *
     * If you specify input parameters that differ from your first request, an error occurs. If you use a different value for `clientToken`, Amazon AppFlow considers it a new call to `UpdateConnectorRegistration`. The token is active for 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the connector. The name is unique for each connector registration in your AWS account.
     */
    public val connectorLabel: kotlin.String? = builder.connectorLabel
    /**
     * Contains information about the configuration of the connector being registered.
     */
    public val connectorProvisioningConfig: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig? = builder.connectorProvisioningConfig
    /**
     * A description about the update that you're applying to the connector.
     */
    public val description: kotlin.String? = builder.description

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.UpdateConnectorRegistrationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConnectorRegistrationRequest(")
        append("clientToken=$clientToken,")
        append("connectorLabel=$connectorLabel,")
        append("connectorProvisioningConfig=$connectorProvisioningConfig,")
        append("description=$description")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (connectorLabel?.hashCode() ?: 0)
        result = 31 * result + (connectorProvisioningConfig?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateConnectorRegistrationRequest

        if (clientToken != other.clientToken) return false
        if (connectorLabel != other.connectorLabel) return false
        if (connectorProvisioningConfig != other.connectorProvisioningConfig) return false
        if (description != other.description) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.UpdateConnectorRegistrationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `clientToken` parameter is an idempotency token. It ensures that your `UpdateConnectorRegistration` request completes only once. You choose the value to pass. For example, if you don't receive a response from your request, you can safely retry the request with the same `clientToken` parameter value.
         *
         * If you omit a `clientToken` value, the Amazon Web Services SDK that you are using inserts a value for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own value for other use cases.
         *
         * If you specify input parameters that differ from your first request, an error occurs. If you use a different value for `clientToken`, Amazon AppFlow considers it a new call to `UpdateConnectorRegistration`. The token is active for 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the connector. The name is unique for each connector registration in your AWS account.
         */
        public var connectorLabel: kotlin.String? = null
        /**
         * Contains information about the configuration of the connector being registered.
         */
        public var connectorProvisioningConfig: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig? = null
        /**
         * A description about the update that you're applying to the connector.
         */
        public var description: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.UpdateConnectorRegistrationRequest) : this() {
            this.clientToken = x.clientToken
            this.connectorLabel = x.connectorLabel
            this.connectorProvisioningConfig = x.connectorProvisioningConfig
            this.description = x.description
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.UpdateConnectorRegistrationRequest = UpdateConnectorRegistrationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig] inside the given [block]
         */
        public fun connectorProvisioningConfig(block: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig.Builder.() -> kotlin.Unit) {
            this.connectorProvisioningConfig = aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
