// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The properties that are applied when Snowflake is being used as a destination.
 */
public class SnowflakeDestinationProperties private constructor(builder: Builder) {
    /**
     * The object key for the destination bucket in which Amazon AppFlow places the files.
     */
    public val bucketPrefix: kotlin.String? = builder.bucketPrefix
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
     */
    public val errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = builder.errorHandlingConfig
    /**
     * The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
     */
    public val intermediateBucketName: kotlin.String = requireNotNull(builder.intermediateBucketName) { "A non-null value must be provided for intermediateBucketName" }
    /**
     * The object specified in the Snowflake flow destination.
     */
    public val `object`: kotlin.String = requireNotNull(builder.`object`) { "A non-null value must be provided for `object`" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.SnowflakeDestinationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnowflakeDestinationProperties(")
        append("bucketPrefix=$bucketPrefix,")
        append("errorHandlingConfig=$errorHandlingConfig,")
        append("intermediateBucketName=$intermediateBucketName,")
        append("object=$`object`")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketPrefix?.hashCode() ?: 0
        result = 31 * result + (errorHandlingConfig?.hashCode() ?: 0)
        result = 31 * result + (intermediateBucketName.hashCode())
        result = 31 * result + (`object`.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnowflakeDestinationProperties

        if (bucketPrefix != other.bucketPrefix) return false
        if (errorHandlingConfig != other.errorHandlingConfig) return false
        if (intermediateBucketName != other.intermediateBucketName) return false
        if (`object` != other.`object`) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.SnowflakeDestinationProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         */
        public var bucketPrefix: kotlin.String? = null
        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
         */
        public var errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = null
        /**
         * The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
         */
        public var intermediateBucketName: kotlin.String? = null
        /**
         * The object specified in the Snowflake flow destination.
         */
        public var `object`: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.SnowflakeDestinationProperties) : this() {
            this.bucketPrefix = x.bucketPrefix
            this.errorHandlingConfig = x.errorHandlingConfig
            this.intermediateBucketName = x.intermediateBucketName
            this.`object` = x.`object`
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.SnowflakeDestinationProperties = SnowflakeDestinationProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig] inside the given [block]
         */
        public fun errorHandlingConfig(block: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.Builder.() -> kotlin.Unit) {
            this.errorHandlingConfig = aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (intermediateBucketName == null) intermediateBucketName = ""
            if (`object` == null) `object` = ""
            return this
        }
    }
}
