// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The connector-specific profile properties required when using Salesforce.
 */
public class SalesforceConnectorProfileProperties private constructor(builder: Builder) {
    /**
     * The location of the Salesforce resource.
     */
    public val instanceUrl: kotlin.String? = builder.instanceUrl
    /**
     * Indicates whether the connector profile applies to a sandbox or production environment.
     */
    public val isSandboxEnvironment: kotlin.Boolean = builder.isSandboxEnvironment
    /**
     * If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow uses the private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends private calls through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services infrastructure without being exposed to the public internet.
     *
     * Set either of the following values:
     *
     * ## true
     * Amazon AppFlow sends all calls to Salesforce over the private network.
     *
     * These private calls are:
     * + Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and their fields.
     * + Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
     * + Calls to transfer your Salesforce records as part of a flow run.
     *
     * ## false
     * The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public internet.
     *
     * The public calls are:
     * + Calls to get metadata about your Salesforce records.
     * + Calls to get or refresh access tokens.
     * The private calls are:
     * + Calls to transfer your Salesforce records as part of a flow run.
     */
    public val usePrivateLinkForMetadataAndAuthorization: kotlin.Boolean = builder.usePrivateLinkForMetadataAndAuthorization

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.SalesforceConnectorProfileProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SalesforceConnectorProfileProperties(")
        append("instanceUrl=$instanceUrl,")
        append("isSandboxEnvironment=$isSandboxEnvironment,")
        append("usePrivateLinkForMetadataAndAuthorization=$usePrivateLinkForMetadataAndAuthorization")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = instanceUrl?.hashCode() ?: 0
        result = 31 * result + (isSandboxEnvironment.hashCode())
        result = 31 * result + (usePrivateLinkForMetadataAndAuthorization.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SalesforceConnectorProfileProperties

        if (instanceUrl != other.instanceUrl) return false
        if (isSandboxEnvironment != other.isSandboxEnvironment) return false
        if (usePrivateLinkForMetadataAndAuthorization != other.usePrivateLinkForMetadataAndAuthorization) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.SalesforceConnectorProfileProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The location of the Salesforce resource.
         */
        public var instanceUrl: kotlin.String? = null
        /**
         * Indicates whether the connector profile applies to a sandbox or production environment.
         */
        public var isSandboxEnvironment: kotlin.Boolean = false
        /**
         * If the connection mode for the connector profile is private, this parameter sets whether Amazon AppFlow uses the private network to send metadata and authorization calls to Salesforce. Amazon AppFlow sends private calls through Amazon Web Services PrivateLink. These calls travel through Amazon Web Services infrastructure without being exposed to the public internet.
         *
         * Set either of the following values:
         *
         * ## true
         * Amazon AppFlow sends all calls to Salesforce over the private network.
         *
         * These private calls are:
         * + Calls to get metadata about your Salesforce records. This metadata describes your Salesforce objects and their fields.
         * + Calls to get or refresh access tokens that allow Amazon AppFlow to access your Salesforce records.
         * + Calls to transfer your Salesforce records as part of a flow run.
         *
         * ## false
         * The default value. Amazon AppFlow sends some calls to Salesforce privately and other calls over the public internet.
         *
         * The public calls are:
         * + Calls to get metadata about your Salesforce records.
         * + Calls to get or refresh access tokens.
         * The private calls are:
         * + Calls to transfer your Salesforce records as part of a flow run.
         */
        public var usePrivateLinkForMetadataAndAuthorization: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.SalesforceConnectorProfileProperties) : this() {
            this.instanceUrl = x.instanceUrl
            this.isSandboxEnvironment = x.isSandboxEnvironment
            this.usePrivateLinkForMetadataAndAuthorization = x.usePrivateLinkForMetadataAndAuthorization
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.SalesforceConnectorProfileProperties = SalesforceConnectorProfileProperties(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
