// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RegisterConnectorRequest private constructor(builder: Builder) {
    /**
     * The `clientToken` parameter is an idempotency token. It ensures that your `RegisterConnector` request completes only once. You choose the value to pass. For example, if you don't receive a response from your request, you can safely retry the request with the same `clientToken` parameter value.
     *
     * If you omit a `clientToken` value, the Amazon Web Services SDK that you are using inserts a value for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own value for other use cases.
     *
     * If you specify input parameters that differ from your first request, an error occurs. If you use a different value for `clientToken`, Amazon AppFlow considers it a new call to `RegisterConnector`. The token is active for 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The name of the connector. The name is unique for each `ConnectorRegistration` in your Amazon Web Services account.
     */
    public val connectorLabel: kotlin.String? = builder.connectorLabel
    /**
     * The provisioning type of the connector. Currently the only supported value is LAMBDA.
     */
    public val connectorProvisioningConfig: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig? = builder.connectorProvisioningConfig
    /**
     * The provisioning type of the connector. Currently the only supported value is LAMBDA.
     */
    public val connectorProvisioningType: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningType? = builder.connectorProvisioningType
    /**
     * A description about the connector that's being registered.
     */
    public val description: kotlin.String? = builder.description

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.RegisterConnectorRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RegisterConnectorRequest(")
        append("clientToken=$clientToken,")
        append("connectorLabel=$connectorLabel,")
        append("connectorProvisioningConfig=$connectorProvisioningConfig,")
        append("connectorProvisioningType=$connectorProvisioningType,")
        append("description=$description")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (connectorLabel?.hashCode() ?: 0)
        result = 31 * result + (connectorProvisioningConfig?.hashCode() ?: 0)
        result = 31 * result + (connectorProvisioningType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RegisterConnectorRequest

        if (clientToken != other.clientToken) return false
        if (connectorLabel != other.connectorLabel) return false
        if (connectorProvisioningConfig != other.connectorProvisioningConfig) return false
        if (connectorProvisioningType != other.connectorProvisioningType) return false
        if (description != other.description) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.RegisterConnectorRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The `clientToken` parameter is an idempotency token. It ensures that your `RegisterConnector` request completes only once. You choose the value to pass. For example, if you don't receive a response from your request, you can safely retry the request with the same `clientToken` parameter value.
         *
         * If you omit a `clientToken` value, the Amazon Web Services SDK that you are using inserts a value for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own value for other use cases.
         *
         * If you specify input parameters that differ from your first request, an error occurs. If you use a different value for `clientToken`, Amazon AppFlow considers it a new call to `RegisterConnector`. The token is active for 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The name of the connector. The name is unique for each `ConnectorRegistration` in your Amazon Web Services account.
         */
        public var connectorLabel: kotlin.String? = null
        /**
         * The provisioning type of the connector. Currently the only supported value is LAMBDA.
         */
        public var connectorProvisioningConfig: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig? = null
        /**
         * The provisioning type of the connector. Currently the only supported value is LAMBDA.
         */
        public var connectorProvisioningType: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningType? = null
        /**
         * A description about the connector that's being registered.
         */
        public var description: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.RegisterConnectorRequest) : this() {
            this.clientToken = x.clientToken
            this.connectorLabel = x.connectorLabel
            this.connectorProvisioningConfig = x.connectorProvisioningConfig
            this.connectorProvisioningType = x.connectorProvisioningType
            this.description = x.description
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.RegisterConnectorRequest = RegisterConnectorRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig] inside the given [block]
         */
        public fun connectorProvisioningConfig(block: aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig.Builder.() -> kotlin.Unit) {
            this.connectorProvisioningConfig = aws.sdk.kotlin.services.appflow.model.ConnectorProvisioningConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
