// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The OAuth 2.0 credentials required for OAuth 2.0 authentication.
 */
public class OAuth2Credentials private constructor(builder: Builder) {
    /**
     * The access token used to access the connector on your behalf.
     */
    public val accessToken: kotlin.String? = builder.accessToken
    /**
     * The identifier for the desired client.
     */
    public val clientId: kotlin.String? = builder.clientId
    /**
     * The client secret used by the OAuth client to authenticate to the authorization server.
     */
    public val clientSecret: kotlin.String? = builder.clientSecret
    /**
     * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
     */
    public val oAuthRequest: aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest? = builder.oAuthRequest
    /**
     * The refresh token used to refresh an expired access token.
     */
    public val refreshToken: kotlin.String? = builder.refreshToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.OAuth2Credentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("OAuth2Credentials(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("clientId=$clientId,")
        append("clientSecret=*** Sensitive Data Redacted ***,")
        append("oAuthRequest=$oAuthRequest,")
        append("refreshToken=$refreshToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (clientId?.hashCode() ?: 0)
        result = 31 * result + (clientSecret?.hashCode() ?: 0)
        result = 31 * result + (oAuthRequest?.hashCode() ?: 0)
        result = 31 * result + (refreshToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as OAuth2Credentials

        if (accessToken != other.accessToken) return false
        if (clientId != other.clientId) return false
        if (clientSecret != other.clientSecret) return false
        if (oAuthRequest != other.oAuthRequest) return false
        if (refreshToken != other.refreshToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.OAuth2Credentials = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The access token used to access the connector on your behalf.
         */
        public var accessToken: kotlin.String? = null
        /**
         * The identifier for the desired client.
         */
        public var clientId: kotlin.String? = null
        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         */
        public var clientSecret: kotlin.String? = null
        /**
         * Used by select connectors for which the OAuth workflow is supported, such as Salesforce, Google Analytics, Marketo, Zendesk, and Slack.
         */
        public var oAuthRequest: aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest? = null
        /**
         * The refresh token used to refresh an expired access token.
         */
        public var refreshToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.OAuth2Credentials) : this() {
            this.accessToken = x.accessToken
            this.clientId = x.clientId
            this.clientSecret = x.clientSecret
            this.oAuthRequest = x.oAuthRequest
            this.refreshToken = x.refreshToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.OAuth2Credentials = OAuth2Credentials(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest] inside the given [block]
         */
        public fun oAuthRequest(block: aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest.Builder.() -> kotlin.Unit) {
            this.oAuthRequest = aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
