// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The connector-specific profile credentials required by Google Analytics.
 */
public class GoogleAnalyticsConnectorProfileCredentials private constructor(builder: Builder) {
    /**
     * The credentials used to access protected Google Analytics resources.
     */
    public val accessToken: kotlin.String? = builder.accessToken
    /**
     * The identifier for the desired client.
     */
    public val clientId: kotlin.String = requireNotNull(builder.clientId) { "A non-null value must be provided for clientId" }
    /**
     * The client secret used by the OAuth client to authenticate to the authorization server.
     */
    public val clientSecret: kotlin.String = requireNotNull(builder.clientSecret) { "A non-null value must be provided for clientSecret" }
    /**
     * The OAuth requirement needed to request security tokens from the connector endpoint.
     */
    public val oAuthRequest: aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest? = builder.oAuthRequest
    /**
     * The credentials used to acquire new access tokens. This is required only for OAuth2 access tokens, and is not required for OAuth1 access tokens.
     */
    public val refreshToken: kotlin.String? = builder.refreshToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.GoogleAnalyticsConnectorProfileCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GoogleAnalyticsConnectorProfileCredentials(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("clientId=$clientId,")
        append("clientSecret=*** Sensitive Data Redacted ***,")
        append("oAuthRequest=$oAuthRequest,")
        append("refreshToken=$refreshToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (clientId.hashCode())
        result = 31 * result + (clientSecret.hashCode())
        result = 31 * result + (oAuthRequest?.hashCode() ?: 0)
        result = 31 * result + (refreshToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GoogleAnalyticsConnectorProfileCredentials

        if (accessToken != other.accessToken) return false
        if (clientId != other.clientId) return false
        if (clientSecret != other.clientSecret) return false
        if (oAuthRequest != other.oAuthRequest) return false
        if (refreshToken != other.refreshToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.GoogleAnalyticsConnectorProfileCredentials = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The credentials used to access protected Google Analytics resources.
         */
        public var accessToken: kotlin.String? = null
        /**
         * The identifier for the desired client.
         */
        public var clientId: kotlin.String? = null
        /**
         * The client secret used by the OAuth client to authenticate to the authorization server.
         */
        public var clientSecret: kotlin.String? = null
        /**
         * The OAuth requirement needed to request security tokens from the connector endpoint.
         */
        public var oAuthRequest: aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest? = null
        /**
         * The credentials used to acquire new access tokens. This is required only for OAuth2 access tokens, and is not required for OAuth1 access tokens.
         */
        public var refreshToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.GoogleAnalyticsConnectorProfileCredentials) : this() {
            this.accessToken = x.accessToken
            this.clientId = x.clientId
            this.clientSecret = x.clientSecret
            this.oAuthRequest = x.oAuthRequest
            this.refreshToken = x.refreshToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.GoogleAnalyticsConnectorProfileCredentials = GoogleAnalyticsConnectorProfileCredentials(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest] inside the given [block]
         */
        public fun oAuthRequest(block: aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest.Builder.() -> kotlin.Unit) {
            this.oAuthRequest = aws.sdk.kotlin.services.appflow.model.ConnectorOAuthRequest.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (clientId == null) clientId = ""
            if (clientSecret == null) clientSecret = ""
            return this
        }
    }
}
