// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
 */
public class ErrorHandlingConfig private constructor(builder: Builder) {
    /**
     * Specifies the name of the Amazon S3 bucket.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * Specifies the Amazon S3 bucket prefix.
     */
    public val bucketPrefix: kotlin.String? = builder.bucketPrefix
    /**
     * Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination.
     */
    public val failOnFirstDestinationError: kotlin.Boolean = builder.failOnFirstDestinationError

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ErrorHandlingConfig(")
        append("bucketName=$bucketName,")
        append("bucketPrefix=$bucketPrefix,")
        append("failOnFirstDestinationError=$failOnFirstDestinationError")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (bucketPrefix?.hashCode() ?: 0)
        result = 31 * result + (failOnFirstDestinationError.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ErrorHandlingConfig

        if (bucketName != other.bucketName) return false
        if (bucketPrefix != other.bucketPrefix) return false
        if (failOnFirstDestinationError != other.failOnFirstDestinationError) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the name of the Amazon S3 bucket.
         */
        public var bucketName: kotlin.String? = null
        /**
         * Specifies the Amazon S3 bucket prefix.
         */
        public var bucketPrefix: kotlin.String? = null
        /**
         * Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination.
         */
        public var failOnFirstDestinationError: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig) : this() {
            this.bucketName = x.bucketName
            this.bucketPrefix = x.bucketPrefix
            this.failOnFirstDestinationError = x.failOnFirstDestinationError
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig = ErrorHandlingConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
