// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains information about the connector runtime settings that are required for flow execution.
 */
public class ConnectorRuntimeSetting private constructor(builder: Builder) {
    /**
     * Contains default values for the connector runtime setting that are supplied by the connector.
     */
    public val connectorSuppliedValueOptions: List<String>? = builder.connectorSuppliedValueOptions
    /**
     * Data type of the connector runtime setting.
     */
    public val dataType: kotlin.String? = builder.dataType
    /**
     * A description about the connector runtime setting.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates whether this connector runtime setting is required.
     */
    public val isRequired: kotlin.Boolean = builder.isRequired
    /**
     * Contains value information about the connector runtime setting.
     */
    public val key: kotlin.String? = builder.key
    /**
     * A label used for connector runtime setting.
     */
    public val label: kotlin.String? = builder.label
    /**
     * Indicates the scope of the connector runtime setting.
     */
    public val scope: kotlin.String? = builder.scope

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ConnectorRuntimeSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ConnectorRuntimeSetting(")
        append("connectorSuppliedValueOptions=$connectorSuppliedValueOptions,")
        append("dataType=$dataType,")
        append("description=$description,")
        append("isRequired=$isRequired,")
        append("key=$key,")
        append("label=$label,")
        append("scope=$scope")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectorSuppliedValueOptions?.hashCode() ?: 0
        result = 31 * result + (dataType?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (isRequired.hashCode())
        result = 31 * result + (key?.hashCode() ?: 0)
        result = 31 * result + (label?.hashCode() ?: 0)
        result = 31 * result + (scope?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ConnectorRuntimeSetting

        if (connectorSuppliedValueOptions != other.connectorSuppliedValueOptions) return false
        if (dataType != other.dataType) return false
        if (description != other.description) return false
        if (isRequired != other.isRequired) return false
        if (key != other.key) return false
        if (label != other.label) return false
        if (scope != other.scope) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ConnectorRuntimeSetting = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Contains default values for the connector runtime setting that are supplied by the connector.
         */
        public var connectorSuppliedValueOptions: List<String>? = null
        /**
         * Data type of the connector runtime setting.
         */
        public var dataType: kotlin.String? = null
        /**
         * A description about the connector runtime setting.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates whether this connector runtime setting is required.
         */
        public var isRequired: kotlin.Boolean = false
        /**
         * Contains value information about the connector runtime setting.
         */
        public var key: kotlin.String? = null
        /**
         * A label used for connector runtime setting.
         */
        public var label: kotlin.String? = null
        /**
         * Indicates the scope of the connector runtime setting.
         */
        public var scope: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ConnectorRuntimeSetting) : this() {
            this.connectorSuppliedValueOptions = x.connectorSuppliedValueOptions
            this.dataType = x.dataType
            this.description = x.description
            this.isRequired = x.isRequired
            this.key = x.key
            this.label = x.label
            this.scope = x.scope
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ConnectorRuntimeSetting = ConnectorRuntimeSetting(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
