// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The connector-specific profile properties required when using SAPOData.
 */
public class SapoDataConnectorProfileProperties private constructor(builder: Builder) {
    /**
     * The location of the SAPOData resource.
     */
    public val applicationHostUrl: kotlin.String = requireNotNull(builder.applicationHostUrl) { "A non-null value must be provided for applicationHostUrl" }
    /**
     * The application path to catalog service.
     */
    public val applicationServicePath: kotlin.String = requireNotNull(builder.applicationServicePath) { "A non-null value must be provided for applicationServicePath" }
    /**
     * The client number for the client creating the connection.
     */
    public val clientNumber: kotlin.String = requireNotNull(builder.clientNumber) { "A non-null value must be provided for clientNumber" }
    /**
     * If you set this parameter to `true`, Amazon AppFlow bypasses the single sign-on (SSO) settings in your SAP account when it accesses your SAP OData instance.
     *
     * Whether you need this option depends on the types of credentials that you applied to your SAP OData connection profile. If your profile uses basic authentication credentials, SAP SSO can prevent Amazon AppFlow from connecting to your account with your username and password. In this case, bypassing SSO makes it possible for Amazon AppFlow to connect successfully. However, if your profile uses OAuth credentials, this parameter has no affect.
     */
    public val disableSso: kotlin.Boolean = builder.disableSso
    /**
     * The logon language of SAPOData instance.
     */
    public val logonLanguage: kotlin.String? = builder.logonLanguage
    /**
     * The SAPOData OAuth properties required for OAuth type authentication.
     */
    public val oAuthProperties: aws.sdk.kotlin.services.appflow.model.OAuthProperties? = builder.oAuthProperties
    /**
     * The port number of the SAPOData instance.
     */
    public val portNumber: kotlin.Int = requireNotNull(builder.portNumber) { "A non-null value must be provided for portNumber" }
    /**
     * The SAPOData Private Link service name to be used for private data transfers.
     */
    public val privateLinkServiceName: kotlin.String? = builder.privateLinkServiceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.SapoDataConnectorProfileProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SapoDataConnectorProfileProperties(")
        append("applicationHostUrl=$applicationHostUrl,")
        append("applicationServicePath=$applicationServicePath,")
        append("clientNumber=$clientNumber,")
        append("disableSso=$disableSso,")
        append("logonLanguage=$logonLanguage,")
        append("oAuthProperties=$oAuthProperties,")
        append("portNumber=$portNumber,")
        append("privateLinkServiceName=$privateLinkServiceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationHostUrl.hashCode()
        result = 31 * result + (applicationServicePath.hashCode())
        result = 31 * result + (clientNumber.hashCode())
        result = 31 * result + (disableSso.hashCode())
        result = 31 * result + (logonLanguage?.hashCode() ?: 0)
        result = 31 * result + (oAuthProperties?.hashCode() ?: 0)
        result = 31 * result + (portNumber)
        result = 31 * result + (privateLinkServiceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SapoDataConnectorProfileProperties

        if (applicationHostUrl != other.applicationHostUrl) return false
        if (applicationServicePath != other.applicationServicePath) return false
        if (clientNumber != other.clientNumber) return false
        if (disableSso != other.disableSso) return false
        if (logonLanguage != other.logonLanguage) return false
        if (oAuthProperties != other.oAuthProperties) return false
        if (portNumber != other.portNumber) return false
        if (privateLinkServiceName != other.privateLinkServiceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.SapoDataConnectorProfileProperties = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The location of the SAPOData resource.
         */
        public var applicationHostUrl: kotlin.String? = null
        /**
         * The application path to catalog service.
         */
        public var applicationServicePath: kotlin.String? = null
        /**
         * The client number for the client creating the connection.
         */
        public var clientNumber: kotlin.String? = null
        /**
         * If you set this parameter to `true`, Amazon AppFlow bypasses the single sign-on (SSO) settings in your SAP account when it accesses your SAP OData instance.
         *
         * Whether you need this option depends on the types of credentials that you applied to your SAP OData connection profile. If your profile uses basic authentication credentials, SAP SSO can prevent Amazon AppFlow from connecting to your account with your username and password. In this case, bypassing SSO makes it possible for Amazon AppFlow to connect successfully. However, if your profile uses OAuth credentials, this parameter has no affect.
         */
        public var disableSso: kotlin.Boolean = false
        /**
         * The logon language of SAPOData instance.
         */
        public var logonLanguage: kotlin.String? = null
        /**
         * The SAPOData OAuth properties required for OAuth type authentication.
         */
        public var oAuthProperties: aws.sdk.kotlin.services.appflow.model.OAuthProperties? = null
        /**
         * The port number of the SAPOData instance.
         */
        public var portNumber: kotlin.Int? = null
        /**
         * The SAPOData Private Link service name to be used for private data transfers.
         */
        public var privateLinkServiceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.SapoDataConnectorProfileProperties) : this() {
            this.applicationHostUrl = x.applicationHostUrl
            this.applicationServicePath = x.applicationServicePath
            this.clientNumber = x.clientNumber
            this.disableSso = x.disableSso
            this.logonLanguage = x.logonLanguage
            this.oAuthProperties = x.oAuthProperties
            this.portNumber = x.portNumber
            this.privateLinkServiceName = x.privateLinkServiceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.SapoDataConnectorProfileProperties = SapoDataConnectorProfileProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.OAuthProperties] inside the given [block]
         */
        public fun oAuthProperties(block: aws.sdk.kotlin.services.appflow.model.OAuthProperties.Builder.() -> kotlin.Unit) {
            this.oAuthProperties = aws.sdk.kotlin.services.appflow.model.OAuthProperties.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (applicationHostUrl == null) applicationHostUrl = ""
            if (applicationServicePath == null) applicationServicePath = ""
            if (clientNumber == null) clientNumber = ""
            if (portNumber == null) portNumber = 0
            return this
        }
    }
}
