// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the end result of the flow run.
 */
public class ExecutionResult private constructor(builder: Builder) {
    /**
     * The total number of bytes processed by the flow run.
     */
    public val bytesProcessed: kotlin.Long? = builder.bytesProcessed
    /**
     * The total number of bytes written as a result of the flow run.
     */
    public val bytesWritten: kotlin.Long? = builder.bytesWritten
    /**
     * Provides any error message information related to the flow run.
     */
    public val errorInfo: aws.sdk.kotlin.services.appflow.model.ErrorInfo? = builder.errorInfo
    /**
     * The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP application.
     */
    public val maxPageSize: kotlin.Long? = builder.maxPageSize
    /**
     * The number of processes that Amazon AppFlow ran at the same time when it retrieved your data.
     */
    public val numParallelProcesses: kotlin.Long? = builder.numParallelProcesses
    /**
     * The number of records processed in the flow run.
     */
    public val recordsProcessed: kotlin.Long? = builder.recordsProcessed

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ExecutionResult = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ExecutionResult(")
        append("bytesProcessed=$bytesProcessed,")
        append("bytesWritten=$bytesWritten,")
        append("errorInfo=$errorInfo,")
        append("maxPageSize=$maxPageSize,")
        append("numParallelProcesses=$numParallelProcesses,")
        append("recordsProcessed=$recordsProcessed")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bytesProcessed?.hashCode() ?: 0
        result = 31 * result + (bytesWritten?.hashCode() ?: 0)
        result = 31 * result + (errorInfo?.hashCode() ?: 0)
        result = 31 * result + (maxPageSize?.hashCode() ?: 0)
        result = 31 * result + (numParallelProcesses?.hashCode() ?: 0)
        result = 31 * result + (recordsProcessed?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ExecutionResult

        if (bytesProcessed != other.bytesProcessed) return false
        if (bytesWritten != other.bytesWritten) return false
        if (errorInfo != other.errorInfo) return false
        if (maxPageSize != other.maxPageSize) return false
        if (numParallelProcesses != other.numParallelProcesses) return false
        if (recordsProcessed != other.recordsProcessed) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ExecutionResult = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The total number of bytes processed by the flow run.
         */
        public var bytesProcessed: kotlin.Long? = null
        /**
         * The total number of bytes written as a result of the flow run.
         */
        public var bytesWritten: kotlin.Long? = null
        /**
         * Provides any error message information related to the flow run.
         */
        public var errorInfo: aws.sdk.kotlin.services.appflow.model.ErrorInfo? = null
        /**
         * The maximum number of records that Amazon AppFlow receives in each page of the response from your SAP application.
         */
        public var maxPageSize: kotlin.Long? = null
        /**
         * The number of processes that Amazon AppFlow ran at the same time when it retrieved your data.
         */
        public var numParallelProcesses: kotlin.Long? = null
        /**
         * The number of records processed in the flow run.
         */
        public var recordsProcessed: kotlin.Long? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ExecutionResult) : this() {
            this.bytesProcessed = x.bytesProcessed
            this.bytesWritten = x.bytesWritten
            this.errorInfo = x.errorInfo
            this.maxPageSize = x.maxPageSize
            this.numParallelProcesses = x.numParallelProcesses
            this.recordsProcessed = x.recordsProcessed
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ExecutionResult = ExecutionResult(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ErrorInfo] inside the given [block]
         */
        public fun errorInfo(block: aws.sdk.kotlin.services.appflow.model.ErrorInfo.Builder.() -> kotlin.Unit) {
            this.errorInfo = aws.sdk.kotlin.services.appflow.model.ErrorInfo.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
