// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The properties that are applied when Salesforce is being used as a source.
 */
public class SalesforceSourceProperties private constructor(builder: Builder) {
    /**
     * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data from Salesforce.
     *
     * ## AUTOMATIC
     * The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers from Salesforce. If your flow transfers fewer than 1,000,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
     *
     * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900,000 records, and it might use Bulk API 2.0 on the next day to transfer 1,100,000 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
     *
     * By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
     *
     * ## BULKV2
     * Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.
     *
     * Note that Bulk API 2.0 does not transfer Salesforce compound fields.
     *
     * ## REST_SYNC
     * Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail wituh a timed out error.
     */
    public val dataTransferApi: aws.sdk.kotlin.services.appflow.model.SalesforceDataTransferApi? = builder.dataTransferApi
    /**
     * The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
     */
    public val enableDynamicFieldUpdate: kotlin.Boolean = builder.enableDynamicFieldUpdate
    /**
     * Indicates whether Amazon AppFlow includes deleted files in the flow run.
     */
    public val includeDeletedRecords: kotlin.Boolean = builder.includeDeletedRecords
    /**
     * The object specified in the Salesforce flow source.
     */
    public val `object`: kotlin.String = requireNotNull(builder.`object`) { "A non-null value must be provided for `object`" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.SalesforceSourceProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SalesforceSourceProperties(")
        append("dataTransferApi=$dataTransferApi,")
        append("enableDynamicFieldUpdate=$enableDynamicFieldUpdate,")
        append("includeDeletedRecords=$includeDeletedRecords,")
        append("object=$`object`")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferApi?.hashCode() ?: 0
        result = 31 * result + (enableDynamicFieldUpdate.hashCode())
        result = 31 * result + (includeDeletedRecords.hashCode())
        result = 31 * result + (`object`.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SalesforceSourceProperties

        if (dataTransferApi != other.dataTransferApi) return false
        if (enableDynamicFieldUpdate != other.enableDynamicFieldUpdate) return false
        if (includeDeletedRecords != other.includeDeletedRecords) return false
        if (`object` != other.`object`) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.SalesforceSourceProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data from Salesforce.
         *
         * ## AUTOMATIC
         * The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers from Salesforce. If your flow transfers fewer than 1,000,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
         *
         * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900,000 records, and it might use Bulk API 2.0 on the next day to transfer 1,100,000 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
         *
         * By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
         *
         * ## BULKV2
         * Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.
         *
         * Note that Bulk API 2.0 does not transfer Salesforce compound fields.
         *
         * ## REST_SYNC
         * Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail wituh a timed out error.
         */
        public var dataTransferApi: aws.sdk.kotlin.services.appflow.model.SalesforceDataTransferApi? = null
        /**
         * The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
         */
        public var enableDynamicFieldUpdate: kotlin.Boolean = false
        /**
         * Indicates whether Amazon AppFlow includes deleted files in the flow run.
         */
        public var includeDeletedRecords: kotlin.Boolean = false
        /**
         * The object specified in the Salesforce flow source.
         */
        public var `object`: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.SalesforceSourceProperties) : this() {
            this.dataTransferApi = x.dataTransferApi
            this.enableDynamicFieldUpdate = x.enableDynamicFieldUpdate
            this.includeDeletedRecords = x.includeDeletedRecords
            this.`object` = x.`object`
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.SalesforceSourceProperties = SalesforceSourceProperties(this)

        internal fun correctErrors(): Builder {
            if (`object` == null) `object` = ""
            return this
        }
    }
}
