// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * Specifies elements that Amazon AppFlow includes in the file and folder names in the flow destination.
 */
public class PrefixConfig private constructor(builder: Builder) {
    /**
     * Specifies whether the destination file path includes either or both of the following elements:
     *
     * ## EXECUTION_ID
     * The ID that Amazon AppFlow assigns to the flow run.
     *
     * ## SCHEMA_VERSION
     * The version number of your data schema. Amazon AppFlow assigns this version number. The version number increases by one when you change any of the following settings in your flow configuration:
     * + Source-to-destination field mappings
     * + Field data types
     * + Partition keys
     */
    public val pathPrefixHierarchy: List<PathPrefix>? = builder.pathPrefixHierarchy
    /**
     * Determines the level of granularity for the date and time that's included in the prefix.
     */
    public val prefixFormat: aws.sdk.kotlin.services.appflow.model.PrefixFormat? = builder.prefixFormat
    /**
     * Determines the format of the prefix, and whether it applies to the file name, file path, or both.
     */
    public val prefixType: aws.sdk.kotlin.services.appflow.model.PrefixType? = builder.prefixType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.PrefixConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PrefixConfig(")
        append("pathPrefixHierarchy=$pathPrefixHierarchy,")
        append("prefixFormat=$prefixFormat,")
        append("prefixType=$prefixType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = pathPrefixHierarchy?.hashCode() ?: 0
        result = 31 * result + (prefixFormat?.hashCode() ?: 0)
        result = 31 * result + (prefixType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PrefixConfig

        if (pathPrefixHierarchy != other.pathPrefixHierarchy) return false
        if (prefixFormat != other.prefixFormat) return false
        if (prefixType != other.prefixType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.PrefixConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the destination file path includes either or both of the following elements:
         *
         * ## EXECUTION_ID
         * The ID that Amazon AppFlow assigns to the flow run.
         *
         * ## SCHEMA_VERSION
         * The version number of your data schema. Amazon AppFlow assigns this version number. The version number increases by one when you change any of the following settings in your flow configuration:
         * + Source-to-destination field mappings
         * + Field data types
         * + Partition keys
         */
        public var pathPrefixHierarchy: List<PathPrefix>? = null
        /**
         * Determines the level of granularity for the date and time that's included in the prefix.
         */
        public var prefixFormat: aws.sdk.kotlin.services.appflow.model.PrefixFormat? = null
        /**
         * Determines the format of the prefix, and whether it applies to the file name, file path, or both.
         */
        public var prefixType: aws.sdk.kotlin.services.appflow.model.PrefixType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.PrefixConfig) : this() {
            this.pathPrefixHierarchy = x.pathPrefixHierarchy
            this.prefixFormat = x.prefixFormat
            this.prefixType = x.prefixType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.PrefixConfig = PrefixConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
