// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The connector-specific profile credentials that are required when using the custom connector.
 */
public class CustomConnectorProfileCredentials private constructor(builder: Builder) {
    /**
     * The API keys required for the authentication of the user.
     */
    public val apiKey: aws.sdk.kotlin.services.appflow.model.ApiKeyCredentials? = builder.apiKey
    /**
     * The authentication type that the custom connector uses for authenticating while creating a connector profile.
     */
    public val authenticationType: aws.sdk.kotlin.services.appflow.model.AuthenticationType = requireNotNull(builder.authenticationType) { "A non-null value must be provided for authenticationType" }
    /**
     * The basic credentials that are required for the authentication of the user.
     */
    public val basic: aws.sdk.kotlin.services.appflow.model.BasicAuthCredentials? = builder.basic
    /**
     * If the connector uses the custom authentication mechanism, this holds the required credentials.
     */
    public val custom: aws.sdk.kotlin.services.appflow.model.CustomAuthCredentials? = builder.custom
    /**
     * The OAuth 2.0 credentials required for the authentication of the user.
     */
    public val oauth2: aws.sdk.kotlin.services.appflow.model.OAuth2Credentials? = builder.oauth2

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.CustomConnectorProfileCredentials = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomConnectorProfileCredentials(")
        append("apiKey=$apiKey,")
        append("authenticationType=$authenticationType,")
        append("basic=$basic,")
        append("custom=$custom,")
        append("oauth2=$oauth2")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKey?.hashCode() ?: 0
        result = 31 * result + (authenticationType.hashCode())
        result = 31 * result + (basic?.hashCode() ?: 0)
        result = 31 * result + (custom?.hashCode() ?: 0)
        result = 31 * result + (oauth2?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomConnectorProfileCredentials

        if (apiKey != other.apiKey) return false
        if (authenticationType != other.authenticationType) return false
        if (basic != other.basic) return false
        if (custom != other.custom) return false
        if (oauth2 != other.oauth2) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.CustomConnectorProfileCredentials = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The API keys required for the authentication of the user.
         */
        public var apiKey: aws.sdk.kotlin.services.appflow.model.ApiKeyCredentials? = null
        /**
         * The authentication type that the custom connector uses for authenticating while creating a connector profile.
         */
        public var authenticationType: aws.sdk.kotlin.services.appflow.model.AuthenticationType? = null
        /**
         * The basic credentials that are required for the authentication of the user.
         */
        public var basic: aws.sdk.kotlin.services.appflow.model.BasicAuthCredentials? = null
        /**
         * If the connector uses the custom authentication mechanism, this holds the required credentials.
         */
        public var custom: aws.sdk.kotlin.services.appflow.model.CustomAuthCredentials? = null
        /**
         * The OAuth 2.0 credentials required for the authentication of the user.
         */
        public var oauth2: aws.sdk.kotlin.services.appflow.model.OAuth2Credentials? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.CustomConnectorProfileCredentials) : this() {
            this.apiKey = x.apiKey
            this.authenticationType = x.authenticationType
            this.basic = x.basic
            this.custom = x.custom
            this.oauth2 = x.oauth2
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.CustomConnectorProfileCredentials = CustomConnectorProfileCredentials(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ApiKeyCredentials] inside the given [block]
         */
        public fun apiKey(block: aws.sdk.kotlin.services.appflow.model.ApiKeyCredentials.Builder.() -> kotlin.Unit) {
            this.apiKey = aws.sdk.kotlin.services.appflow.model.ApiKeyCredentials.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.BasicAuthCredentials] inside the given [block]
         */
        public fun basic(block: aws.sdk.kotlin.services.appflow.model.BasicAuthCredentials.Builder.() -> kotlin.Unit) {
            this.basic = aws.sdk.kotlin.services.appflow.model.BasicAuthCredentials.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.CustomAuthCredentials] inside the given [block]
         */
        public fun custom(block: aws.sdk.kotlin.services.appflow.model.CustomAuthCredentials.Builder.() -> kotlin.Unit) {
            this.custom = aws.sdk.kotlin.services.appflow.model.CustomAuthCredentials.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.OAuth2Credentials] inside the given [block]
         */
        public fun oauth2(block: aws.sdk.kotlin.services.appflow.model.OAuth2Credentials.Builder.() -> kotlin.Unit) {
            this.oauth2 = aws.sdk.kotlin.services.appflow.model.OAuth2Credentials.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (authenticationType == null) authenticationType = AuthenticationType.SdkUnknown("no value provided")
            return this
        }
    }
}
