// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The properties that are applied when Amazon S3 is used as a destination.
 */
public class S3DestinationProperties private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
     */
    public val bucketName: kotlin.String = requireNotNull(builder.bucketName) { "A non-null value must be provided for bucketName" }
    /**
     * The object key for the destination bucket in which Amazon AppFlow places the files.
     */
    public val bucketPrefix: kotlin.String? = builder.bucketPrefix
    /**
     * The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
     */
    public val s3OutputFormatConfig: aws.sdk.kotlin.services.appflow.model.S3OutputFormatConfig? = builder.s3OutputFormatConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.S3DestinationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3DestinationProperties(")
        append("bucketName=$bucketName,")
        append("bucketPrefix=$bucketPrefix,")
        append("s3OutputFormatConfig=$s3OutputFormatConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName.hashCode()
        result = 31 * result + (bucketPrefix?.hashCode() ?: 0)
        result = 31 * result + (s3OutputFormatConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3DestinationProperties

        if (bucketName != other.bucketName) return false
        if (bucketPrefix != other.bucketPrefix) return false
        if (s3OutputFormatConfig != other.s3OutputFormatConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.S3DestinationProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         */
        public var bucketPrefix: kotlin.String? = null
        /**
         * The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
         */
        public var s3OutputFormatConfig: aws.sdk.kotlin.services.appflow.model.S3OutputFormatConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.S3DestinationProperties) : this() {
            this.bucketName = x.bucketName
            this.bucketPrefix = x.bucketPrefix
            this.s3OutputFormatConfig = x.s3OutputFormatConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.S3DestinationProperties = S3DestinationProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.S3OutputFormatConfig] inside the given [block]
         */
        public fun s3OutputFormatConfig(block: aws.sdk.kotlin.services.appflow.model.S3OutputFormatConfig.Builder.() -> kotlin.Unit) {
            this.s3OutputFormatConfig = aws.sdk.kotlin.services.appflow.model.S3OutputFormatConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            return this
        }
    }
}
