// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The properties that are applied when Zendesk is used as a destination.
 */
public class ZendeskDestinationProperties private constructor(builder: Builder) {
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
     */
    public val errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = builder.errorHandlingConfig
    /**
     * A list of field names that can be used as an ID field when performing a write operation.
     */
    public val idFieldNames: List<String>? = builder.idFieldNames
    /**
     * The object specified in the Zendesk flow destination.
     */
    public val `object`: kotlin.String = requireNotNull(builder.`object`) { "A non-null value must be provided for `object`" }
    /**
     * The possible write operations in the destination connector. When this value is not provided, this defaults to the `INSERT` operation.
     */
    public val writeOperationType: aws.sdk.kotlin.services.appflow.model.WriteOperationType? = builder.writeOperationType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ZendeskDestinationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ZendeskDestinationProperties(")
        append("errorHandlingConfig=$errorHandlingConfig,")
        append("idFieldNames=$idFieldNames,")
        append("object=$`object`,")
        append("writeOperationType=$writeOperationType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorHandlingConfig?.hashCode() ?: 0
        result = 31 * result + (idFieldNames?.hashCode() ?: 0)
        result = 31 * result + (`object`.hashCode())
        result = 31 * result + (writeOperationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ZendeskDestinationProperties

        if (errorHandlingConfig != other.errorHandlingConfig) return false
        if (idFieldNames != other.idFieldNames) return false
        if (`object` != other.`object`) return false
        if (writeOperationType != other.writeOperationType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ZendeskDestinationProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
         */
        public var errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = null
        /**
         * A list of field names that can be used as an ID field when performing a write operation.
         */
        public var idFieldNames: List<String>? = null
        /**
         * The object specified in the Zendesk flow destination.
         */
        public var `object`: kotlin.String? = null
        /**
         * The possible write operations in the destination connector. When this value is not provided, this defaults to the `INSERT` operation.
         */
        public var writeOperationType: aws.sdk.kotlin.services.appflow.model.WriteOperationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ZendeskDestinationProperties) : this() {
            this.errorHandlingConfig = x.errorHandlingConfig
            this.idFieldNames = x.idFieldNames
            this.`object` = x.`object`
            this.writeOperationType = x.writeOperationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ZendeskDestinationProperties = ZendeskDestinationProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig] inside the given [block]
         */
        public fun errorHandlingConfig(block: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.Builder.() -> kotlin.Unit) {
            this.errorHandlingConfig = aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (`object` == null) `object` = ""
            return this
        }
    }
}
