// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The properties that are applied when Upsolver is used as a destination.
 */
public class UpsolverDestinationProperties private constructor(builder: Builder) {
    /**
     * The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files.
     */
    public val bucketPrefix: kotlin.String? = builder.bucketPrefix
    /**
     * The configuration that determines how data is formatted when Upsolver is used as the flow destination.
     */
    public val s3OutputFormatConfig: aws.sdk.kotlin.services.appflow.model.UpsolverS3OutputFormatConfig? = builder.s3OutputFormatConfig

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.UpsolverDestinationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpsolverDestinationProperties(")
        append("bucketName=$bucketName,")
        append("bucketPrefix=$bucketPrefix,")
        append("s3OutputFormatConfig=$s3OutputFormatConfig")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketName?.hashCode() ?: 0
        result = 31 * result + (bucketPrefix?.hashCode() ?: 0)
        result = 31 * result + (s3OutputFormatConfig?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpsolverDestinationProperties

        if (bucketName != other.bucketName) return false
        if (bucketPrefix != other.bucketPrefix) return false
        if (s3OutputFormatConfig != other.s3OutputFormatConfig) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.UpsolverDestinationProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files.
         */
        public var bucketPrefix: kotlin.String? = null
        /**
         * The configuration that determines how data is formatted when Upsolver is used as the flow destination.
         */
        public var s3OutputFormatConfig: aws.sdk.kotlin.services.appflow.model.UpsolverS3OutputFormatConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.UpsolverDestinationProperties) : this() {
            this.bucketName = x.bucketName
            this.bucketPrefix = x.bucketPrefix
            this.s3OutputFormatConfig = x.s3OutputFormatConfig
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.UpsolverDestinationProperties = UpsolverDestinationProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.UpsolverS3OutputFormatConfig] inside the given [block]
         */
        public fun s3OutputFormatConfig(block: aws.sdk.kotlin.services.appflow.model.UpsolverS3OutputFormatConfig.Builder.() -> kotlin.Unit) {
            this.s3OutputFormatConfig = aws.sdk.kotlin.services.appflow.model.UpsolverS3OutputFormatConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            if (s3OutputFormatConfig == null) s3OutputFormatConfig = UpsolverS3OutputFormatConfig.Builder().correctErrors().build()
            return this
        }
    }
}
