// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



public class UpdateConnectorProfileRequest private constructor(builder: Builder) {
    /**
     * The `clientToken` parameter is an idempotency token. It ensures that your `UpdateConnectorProfile` request completes only once. You choose the value to pass. For example, if you don't receive a response from your request, you can safely retry the request with the same `clientToken` parameter value.
     *
     * If you omit a `clientToken` value, the Amazon Web Services SDK that you are using inserts a value for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own value for other use cases.
     *
     * If you specify input parameters that differ from your first request, an error occurs. If you use a different value for `clientToken`, Amazon AppFlow considers it a new call to `UpdateConnectorProfile`. The token is active for 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Indicates the connection mode and if it is public or private.
     */
    public val connectionMode: aws.sdk.kotlin.services.appflow.model.ConnectionMode? = builder.connectionMode
    /**
     * Defines the connector-specific profile configuration and credentials.
     */
    public val connectorProfileConfig: aws.sdk.kotlin.services.appflow.model.ConnectorProfileConfig? = builder.connectorProfileConfig
    /**
     * The name of the connector profile and is unique for each `ConnectorProfile` in the Amazon Web Services account.
     */
    public val connectorProfileName: kotlin.String? = builder.connectorProfileName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.UpdateConnectorProfileRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateConnectorProfileRequest(")
        append("clientToken=$clientToken,")
        append("connectionMode=$connectionMode,")
        append("connectorProfileConfig=$connectorProfileConfig,")
        append("connectorProfileName=$connectorProfileName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (connectionMode?.hashCode() ?: 0)
        result = 31 * result + (connectorProfileConfig?.hashCode() ?: 0)
        result = 31 * result + (connectorProfileName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateConnectorProfileRequest

        if (clientToken != other.clientToken) return false
        if (connectionMode != other.connectionMode) return false
        if (connectorProfileConfig != other.connectorProfileConfig) return false
        if (connectorProfileName != other.connectorProfileName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.UpdateConnectorProfileRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `clientToken` parameter is an idempotency token. It ensures that your `UpdateConnectorProfile` request completes only once. You choose the value to pass. For example, if you don't receive a response from your request, you can safely retry the request with the same `clientToken` parameter value.
         *
         * If you omit a `clientToken` value, the Amazon Web Services SDK that you are using inserts a value for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own value for other use cases.
         *
         * If you specify input parameters that differ from your first request, an error occurs. If you use a different value for `clientToken`, Amazon AppFlow considers it a new call to `UpdateConnectorProfile`. The token is active for 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Indicates the connection mode and if it is public or private.
         */
        public var connectionMode: aws.sdk.kotlin.services.appflow.model.ConnectionMode? = null
        /**
         * Defines the connector-specific profile configuration and credentials.
         */
        public var connectorProfileConfig: aws.sdk.kotlin.services.appflow.model.ConnectorProfileConfig? = null
        /**
         * The name of the connector profile and is unique for each `ConnectorProfile` in the Amazon Web Services account.
         */
        public var connectorProfileName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.UpdateConnectorProfileRequest) : this() {
            this.clientToken = x.clientToken
            this.connectionMode = x.connectionMode
            this.connectorProfileConfig = x.connectorProfileConfig
            this.connectorProfileName = x.connectorProfileName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.UpdateConnectorProfileRequest = UpdateConnectorProfileRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorProfileConfig] inside the given [block]
         */
        public fun connectorProfileConfig(block: aws.sdk.kotlin.services.appflow.model.ConnectorProfileConfig.Builder.() -> kotlin.Unit) {
            this.connectorProfileConfig = aws.sdk.kotlin.services.appflow.model.ConnectorProfileConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (connectionMode == null) connectionMode = ConnectionMode.SdkUnknown("no value provided")
            if (connectorProfileConfig == null) connectorProfileConfig = ConnectorProfileConfig.Builder().correctErrors().build()
            if (connectorProfileName == null) connectorProfileName = ""
            return this
        }
    }
}
