// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * A class for modeling different type of tasks. Task implementation varies based on the `TaskType`.
 */
public class Task private constructor(builder: Builder) {
    /**
     * The operation to be performed on the provided source fields.
     */
    public val connectorOperator: aws.sdk.kotlin.services.appflow.model.ConnectorOperator? = builder.connectorOperator
    /**
     * A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
     */
    public val destinationField: kotlin.String? = builder.destinationField
    /**
     * The source fields to which a particular task is applied.
     */
    public val sourceFields: List<String>? = builder.sourceFields
    /**
     * A map used to store task-related information. The execution service looks for particular information based on the `TaskType`.
     */
    public val taskProperties: Map<String, String>? = builder.taskProperties
    /**
     * Specifies the particular task implementation that Amazon AppFlow performs.
     */
    public val taskType: aws.sdk.kotlin.services.appflow.model.TaskType? = builder.taskType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.Task = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Task(")
        append("connectorOperator=$connectorOperator,")
        append("destinationField=$destinationField,")
        append("sourceFields=$sourceFields,")
        append("taskProperties=$taskProperties,")
        append("taskType=$taskType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectorOperator?.hashCode() ?: 0
        result = 31 * result + (destinationField?.hashCode() ?: 0)
        result = 31 * result + (sourceFields?.hashCode() ?: 0)
        result = 31 * result + (taskProperties?.hashCode() ?: 0)
        result = 31 * result + (taskType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Task

        if (connectorOperator != other.connectorOperator) return false
        if (destinationField != other.destinationField) return false
        if (sourceFields != other.sourceFields) return false
        if (taskProperties != other.taskProperties) return false
        if (taskType != other.taskType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.Task = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The operation to be performed on the provided source fields.
         */
        public var connectorOperator: aws.sdk.kotlin.services.appflow.model.ConnectorOperator? = null
        /**
         * A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
         */
        public var destinationField: kotlin.String? = null
        /**
         * The source fields to which a particular task is applied.
         */
        public var sourceFields: List<String>? = null
        /**
         * A map used to store task-related information. The execution service looks for particular information based on the `TaskType`.
         */
        public var taskProperties: Map<String, String>? = null
        /**
         * Specifies the particular task implementation that Amazon AppFlow performs.
         */
        public var taskType: aws.sdk.kotlin.services.appflow.model.TaskType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.Task) : this() {
            this.connectorOperator = x.connectorOperator
            this.destinationField = x.destinationField
            this.sourceFields = x.sourceFields
            this.taskProperties = x.taskProperties
            this.taskType = x.taskType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.Task = Task(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ConnectorOperator] inside the given [block]
         */
        public fun connectorOperator(block: aws.sdk.kotlin.services.appflow.model.ConnectorOperator.Builder.() -> kotlin.Unit) {
            this.connectorOperator = aws.sdk.kotlin.services.appflow.model.ConnectorOperator.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (sourceFields == null) sourceFields = emptyList()
            if (taskType == null) taskType = TaskType.SdkUnknown("no value provided")
            return this
        }
    }
}
