// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



public class StartFlowRequest private constructor(builder: Builder) {
    /**
     * The `clientToken` parameter is an idempotency token. It ensures that your `StartFlow` request completes only once. You choose the value to pass. For example, if you don't receive a response from your request, you can safely retry the request with the same `clientToken` parameter value.
     *
     * If you omit a `clientToken` value, the Amazon Web Services SDK that you are using inserts a value for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own value for other use cases.
     *
     * If you specify input parameters that differ from your first request, an error occurs for flows that run on a schedule or based on an event. However, the error doesn't occur for flows that run on demand. You set the conditions that initiate your flow for the `triggerConfig` parameter.
     *
     * If you use a different value for `clientToken`, Amazon AppFlow considers it a new call to `StartFlow`. The token is active for 8 hours.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
     */
    public val flowName: kotlin.String? = builder.flowName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.StartFlowRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartFlowRequest(")
        append("clientToken=$clientToken,")
        append("flowName=$flowName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientToken?.hashCode() ?: 0
        result = 31 * result + (flowName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartFlowRequest

        if (clientToken != other.clientToken) return false
        if (flowName != other.flowName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.StartFlowRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The `clientToken` parameter is an idempotency token. It ensures that your `StartFlow` request completes only once. You choose the value to pass. For example, if you don't receive a response from your request, you can safely retry the request with the same `clientToken` parameter value.
         *
         * If you omit a `clientToken` value, the Amazon Web Services SDK that you are using inserts a value for you. This way, the SDK can safely retry requests multiple times after a network error. You must provide your own value for other use cases.
         *
         * If you specify input parameters that differ from your first request, an error occurs for flows that run on a schedule or based on an event. However, the error doesn't occur for flows that run on demand. You set the conditions that initiate your flow for the `triggerConfig` parameter.
         *
         * If you use a different value for `clientToken`, Amazon AppFlow considers it a new call to `StartFlow`. The token is active for 8 hours.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The specified name of the flow. Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         */
        public var flowName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.StartFlowRequest) : this() {
            this.clientToken = x.clientToken
            this.flowName = x.flowName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.StartFlowRequest = StartFlowRequest(this)

        internal fun correctErrors(): Builder {
            if (flowName == null) flowName = ""
            return this
        }
    }
}
