// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The connector-specific profile properties required when using Snowflake.
 */
public class SnowflakeConnectorProfileProperties private constructor(builder: Builder) {
    /**
     * The name of the account.
     */
    public val accountName: kotlin.String? = builder.accountName
    /**
     * The name of the Amazon S3 bucket associated with Snowflake.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
     */
    public val bucketPrefix: kotlin.String? = builder.bucketPrefix
    /**
     * The Snowflake Private Link service name to be used for private data transfers.
     */
    public val privateLinkServiceName: kotlin.String? = builder.privateLinkServiceName
    /**
     * The Amazon Web Services Region of the Snowflake account.
     */
    public val region: kotlin.String? = builder.region
    /**
     * The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This is written in the following format: < Database>< Schema><stage>.
     */
    public val stage: kotlin.String? = builder.stage
    /**
     * The name of the Snowflake warehouse.
     */
    public val warehouse: kotlin.String? = builder.warehouse

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.SnowflakeConnectorProfileProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SnowflakeConnectorProfileProperties(")
        append("accountName=$accountName,")
        append("bucketName=$bucketName,")
        append("bucketPrefix=$bucketPrefix,")
        append("privateLinkServiceName=$privateLinkServiceName,")
        append("region=$region,")
        append("stage=$stage,")
        append("warehouse=$warehouse")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountName?.hashCode() ?: 0
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (bucketPrefix?.hashCode() ?: 0)
        result = 31 * result + (privateLinkServiceName?.hashCode() ?: 0)
        result = 31 * result + (region?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        result = 31 * result + (warehouse?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SnowflakeConnectorProfileProperties

        if (accountName != other.accountName) return false
        if (bucketName != other.bucketName) return false
        if (bucketPrefix != other.bucketPrefix) return false
        if (privateLinkServiceName != other.privateLinkServiceName) return false
        if (region != other.region) return false
        if (stage != other.stage) return false
        if (warehouse != other.warehouse) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.SnowflakeConnectorProfileProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the account.
         */
        public var accountName: kotlin.String? = null
        /**
         * The name of the Amazon S3 bucket associated with Snowflake.
         */
        public var bucketName: kotlin.String? = null
        /**
         * The bucket path that refers to the Amazon S3 bucket associated with Snowflake.
         */
        public var bucketPrefix: kotlin.String? = null
        /**
         * The Snowflake Private Link service name to be used for private data transfers.
         */
        public var privateLinkServiceName: kotlin.String? = null
        /**
         * The Amazon Web Services Region of the Snowflake account.
         */
        public var region: kotlin.String? = null
        /**
         * The name of the Amazon S3 stage that was created while setting up an Amazon S3 stage in the Snowflake account. This is written in the following format: < Database>< Schema><stage>.
         */
        public var stage: kotlin.String? = null
        /**
         * The name of the Snowflake warehouse.
         */
        public var warehouse: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.SnowflakeConnectorProfileProperties) : this() {
            this.accountName = x.accountName
            this.bucketName = x.bucketName
            this.bucketPrefix = x.bucketPrefix
            this.privateLinkServiceName = x.privateLinkServiceName
            this.region = x.region
            this.stage = x.stage
            this.warehouse = x.warehouse
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.SnowflakeConnectorProfileProperties = SnowflakeConnectorProfileProperties(this)

        internal fun correctErrors(): Builder {
            if (bucketName == null) bucketName = ""
            if (stage == null) stage = ""
            if (warehouse == null) warehouse = ""
            return this
        }
    }
}
