// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The connector metadata specific to Salesforce.
 */
public class SalesforceMetadata private constructor(builder: Builder) {
    /**
     * The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from Salesforce.
     */
    public val dataTransferApis: List<SalesforceDataTransferApi>? = builder.dataTransferApis
    /**
     * The desired authorization scope for the Salesforce account.
     */
    public val oAuthScopes: List<String>? = builder.oAuthScopes
    /**
     * The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
     *
     * ## AUTHORIZATION_CODE
     * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account and authorize Amazon AppFlow to access your records.
     *
     * ## CLIENT_CREDENTIALS
     * Amazon AppFlow passes client credentials (a client ID and client secret) when it requests the access token from Salesforce. You provide these credentials to Amazon AppFlow when you define the connection to your Salesforce account.
     *
     * ## JWT_BEARER
     * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
     */
    public val oauth2GrantTypesSupported: List<OAuth2GrantType>? = builder.oauth2GrantTypesSupported

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.SalesforceMetadata = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SalesforceMetadata(")
        append("dataTransferApis=$dataTransferApis,")
        append("oAuthScopes=$oAuthScopes,")
        append("oauth2GrantTypesSupported=$oauth2GrantTypesSupported")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferApis?.hashCode() ?: 0
        result = 31 * result + (oAuthScopes?.hashCode() ?: 0)
        result = 31 * result + (oauth2GrantTypesSupported?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SalesforceMetadata

        if (dataTransferApis != other.dataTransferApis) return false
        if (oAuthScopes != other.oAuthScopes) return false
        if (oauth2GrantTypesSupported != other.oauth2GrantTypesSupported) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.SalesforceMetadata = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Salesforce APIs that you can have Amazon AppFlow use when your flows transfers data to or from Salesforce.
         */
        public var dataTransferApis: List<SalesforceDataTransferApi>? = null
        /**
         * The desired authorization scope for the Salesforce account.
         */
        public var oAuthScopes: List<String>? = null
        /**
         * The OAuth 2.0 grant types that Amazon AppFlow can use when it requests an access token from Salesforce. Amazon AppFlow requires an access token each time it attempts to access your Salesforce records.
         *
         * ## AUTHORIZATION_CODE
         * Amazon AppFlow passes an authorization code when it requests the access token from Salesforce. Amazon AppFlow receives the authorization code from Salesforce after you log in to your Salesforce account and authorize Amazon AppFlow to access your records.
         *
         * ## CLIENT_CREDENTIALS
         * Amazon AppFlow passes client credentials (a client ID and client secret) when it requests the access token from Salesforce. You provide these credentials to Amazon AppFlow when you define the connection to your Salesforce account.
         *
         * ## JWT_BEARER
         * Amazon AppFlow passes a JSON web token (JWT) when it requests the access token from Salesforce. You provide the JWT to Amazon AppFlow when you define the connection to your Salesforce account. When you use this grant type, you don't need to log in to your Salesforce account to authorize Amazon AppFlow to access your records.
         */
        public var oauth2GrantTypesSupported: List<OAuth2GrantType>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.SalesforceMetadata) : this() {
            this.dataTransferApis = x.dataTransferApis
            this.oAuthScopes = x.oAuthScopes
            this.oauth2GrantTypesSupported = x.oauth2GrantTypesSupported
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.SalesforceMetadata = SalesforceMetadata(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
