// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



public class ResetConnectorMetadataCacheRequest private constructor(builder: Builder) {
    /**
     * The API version that you specified in the connector profile that you’re resetting cached metadata for. You must use this parameter only if the connector supports multiple API versions or if the connector type is CustomConnector.
     *
     * To look up how many versions a connector supports, use the DescribeConnectors action. In the response, find the value that Amazon AppFlow returns for the connectorVersion parameter.
     *
     * To look up the connector type, use the DescribeConnectorProfiles action. In the response, find the value that Amazon AppFlow returns for the connectorType parameter.
     *
     * To look up the API version that you specified in a connector profile, use the DescribeConnectorProfiles action.
     */
    public val apiVersion: kotlin.String? = builder.apiVersion
    /**
     * Use this parameter if you want to reset cached metadata about the details for an individual entity.
     *
     * If you don't include this parameter in your request, Amazon AppFlow only resets cached metadata about entity names, not entity details.
     */
    public val connectorEntityName: kotlin.String? = builder.connectorEntityName
    /**
     * The name of the connector profile that you want to reset cached metadata for.
     *
     * You can omit this parameter if you're resetting the cache for any of the following connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're resetting the cache for any other connector, you must include this parameter in your request.
     */
    public val connectorProfileName: kotlin.String? = builder.connectorProfileName
    /**
     * The type of connector to reset cached metadata for.
     *
     * You must include this parameter in your request if you're resetting the cache for any of the following connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're resetting the cache for any other connector, you can omit this parameter from your request.
     */
    public val connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = builder.connectorType
    /**
     * Use this parameter only if you’re resetting the cached metadata about a nested entity. Only some connectors support nested entities. A nested entity is one that has another entity as a parent. To use this parameter, specify the name of the parent entity.
     *
     * To look up the parent-child relationship of entities, you can send a ListConnectorEntities request that omits the entitiesPath parameter. Amazon AppFlow will return a list of top-level entities. For each one, it indicates whether the entity has nested entities. Then, in a subsequent ListConnectorEntities request, you can specify a parent entity name for the entitiesPath parameter. Amazon AppFlow will return a list of the child entities for that parent.
     */
    public val entitiesPath: kotlin.String? = builder.entitiesPath

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ResetConnectorMetadataCacheRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResetConnectorMetadataCacheRequest(")
        append("apiVersion=$apiVersion,")
        append("connectorEntityName=$connectorEntityName,")
        append("connectorProfileName=$connectorProfileName,")
        append("connectorType=$connectorType,")
        append("entitiesPath=$entitiesPath")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiVersion?.hashCode() ?: 0
        result = 31 * result + (connectorEntityName?.hashCode() ?: 0)
        result = 31 * result + (connectorProfileName?.hashCode() ?: 0)
        result = 31 * result + (connectorType?.hashCode() ?: 0)
        result = 31 * result + (entitiesPath?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResetConnectorMetadataCacheRequest

        if (apiVersion != other.apiVersion) return false
        if (connectorEntityName != other.connectorEntityName) return false
        if (connectorProfileName != other.connectorProfileName) return false
        if (connectorType != other.connectorType) return false
        if (entitiesPath != other.entitiesPath) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ResetConnectorMetadataCacheRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The API version that you specified in the connector profile that you’re resetting cached metadata for. You must use this parameter only if the connector supports multiple API versions or if the connector type is CustomConnector.
         *
         * To look up how many versions a connector supports, use the DescribeConnectors action. In the response, find the value that Amazon AppFlow returns for the connectorVersion parameter.
         *
         * To look up the connector type, use the DescribeConnectorProfiles action. In the response, find the value that Amazon AppFlow returns for the connectorType parameter.
         *
         * To look up the API version that you specified in a connector profile, use the DescribeConnectorProfiles action.
         */
        public var apiVersion: kotlin.String? = null
        /**
         * Use this parameter if you want to reset cached metadata about the details for an individual entity.
         *
         * If you don't include this parameter in your request, Amazon AppFlow only resets cached metadata about entity names, not entity details.
         */
        public var connectorEntityName: kotlin.String? = null
        /**
         * The name of the connector profile that you want to reset cached metadata for.
         *
         * You can omit this parameter if you're resetting the cache for any of the following connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're resetting the cache for any other connector, you must include this parameter in your request.
         */
        public var connectorProfileName: kotlin.String? = null
        /**
         * The type of connector to reset cached metadata for.
         *
         * You must include this parameter in your request if you're resetting the cache for any of the following connectors: Amazon Connect, Amazon EventBridge, Amazon Lookout for Metrics, Amazon S3, or Upsolver. If you're resetting the cache for any other connector, you can omit this parameter from your request.
         */
        public var connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = null
        /**
         * Use this parameter only if you’re resetting the cached metadata about a nested entity. Only some connectors support nested entities. A nested entity is one that has another entity as a parent. To use this parameter, specify the name of the parent entity.
         *
         * To look up the parent-child relationship of entities, you can send a ListConnectorEntities request that omits the entitiesPath parameter. Amazon AppFlow will return a list of top-level entities. For each one, it indicates whether the entity has nested entities. Then, in a subsequent ListConnectorEntities request, you can specify a parent entity name for the entitiesPath parameter. Amazon AppFlow will return a list of the child entities for that parent.
         */
        public var entitiesPath: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ResetConnectorMetadataCacheRequest) : this() {
            this.apiVersion = x.apiVersion
            this.connectorEntityName = x.connectorEntityName
            this.connectorProfileName = x.connectorProfileName
            this.connectorType = x.connectorType
            this.entitiesPath = x.entitiesPath
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ResetConnectorMetadataCacheRequest = ResetConnectorMetadataCacheRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
