// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The properties that are applied when Amazon Redshift is being used as a destination.
 */
public class RedshiftDestinationProperties private constructor(builder: Builder) {
    /**
     * The object key for the bucket in which Amazon AppFlow places the destination files.
     */
    public val bucketPrefix: kotlin.String? = builder.bucketPrefix
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
     */
    public val errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = builder.errorHandlingConfig
    /**
     * The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift.
     */
    public val intermediateBucketName: kotlin.String? = builder.intermediateBucketName
    /**
     * The object specified in the Amazon Redshift flow destination.
     */
    public val `object`: kotlin.String? = builder.`object`

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.RedshiftDestinationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RedshiftDestinationProperties(")
        append("bucketPrefix=$bucketPrefix,")
        append("errorHandlingConfig=$errorHandlingConfig,")
        append("intermediateBucketName=$intermediateBucketName,")
        append("object=$`object`")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucketPrefix?.hashCode() ?: 0
        result = 31 * result + (errorHandlingConfig?.hashCode() ?: 0)
        result = 31 * result + (intermediateBucketName?.hashCode() ?: 0)
        result = 31 * result + (`object`?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RedshiftDestinationProperties

        if (bucketPrefix != other.bucketPrefix) return false
        if (errorHandlingConfig != other.errorHandlingConfig) return false
        if (intermediateBucketName != other.intermediateBucketName) return false
        if (`object` != other.`object`) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.RedshiftDestinationProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The object key for the bucket in which Amazon AppFlow places the destination files.
         */
        public var bucketPrefix: kotlin.String? = null
        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
         */
        public var errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = null
        /**
         * The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift.
         */
        public var intermediateBucketName: kotlin.String? = null
        /**
         * The object specified in the Amazon Redshift flow destination.
         */
        public var `object`: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.RedshiftDestinationProperties) : this() {
            this.bucketPrefix = x.bucketPrefix
            this.errorHandlingConfig = x.errorHandlingConfig
            this.intermediateBucketName = x.intermediateBucketName
            this.`object` = x.`object`
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.RedshiftDestinationProperties = RedshiftDestinationProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig] inside the given [block]
         */
        public fun errorHandlingConfig(block: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.Builder.() -> kotlin.Unit) {
            this.errorHandlingConfig = aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (intermediateBucketName == null) intermediateBucketName = ""
            if (`object` == null) `object` = ""
            return this
        }
    }
}
