// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * Specifies the configuration that Amazon AppFlow uses when it catalogs your data with the Glue Data Catalog. When Amazon AppFlow catalogs your data, it stores metadata in Data Catalog tables. This metadata represents the data that's transferred by the flow that you configure with these settings.
 *
 * You can configure a flow with these settings only when the flow destination is Amazon S3.
 */
public class GlueDataCatalogConfig private constructor(builder: Builder) {
    /**
     * The name of the Data Catalog database that stores the metadata tables that Amazon AppFlow creates in your Amazon Web Services account. These tables contain metadata for the data that's transferred by the flow that you configure with this parameter.
     *
     * When you configure a new flow with this parameter, you must specify an existing database.
     */
    public val databaseName: kotlin.String? = builder.databaseName
    /**
     * The Amazon Resource Name (ARN) of an IAM role that grants Amazon AppFlow the permissions it needs to create Data Catalog tables, databases, and partitions.
     *
     * For an example IAM policy that has the required permissions, see [Identity-based policy examples for Amazon AppFlow](https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_id-based-policy-examples.html).
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A naming prefix for each Data Catalog table that Amazon AppFlow creates for the flow that you configure with this setting. Amazon AppFlow adds the prefix to the beginning of the each table name.
     */
    public val tablePrefix: kotlin.String? = builder.tablePrefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.GlueDataCatalogConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GlueDataCatalogConfig(")
        append("databaseName=$databaseName,")
        append("roleArn=$roleArn,")
        append("tablePrefix=$tablePrefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = databaseName?.hashCode() ?: 0
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (tablePrefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GlueDataCatalogConfig

        if (databaseName != other.databaseName) return false
        if (roleArn != other.roleArn) return false
        if (tablePrefix != other.tablePrefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.GlueDataCatalogConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the Data Catalog database that stores the metadata tables that Amazon AppFlow creates in your Amazon Web Services account. These tables contain metadata for the data that's transferred by the flow that you configure with this parameter.
         *
         * When you configure a new flow with this parameter, you must specify an existing database.
         */
        public var databaseName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of an IAM role that grants Amazon AppFlow the permissions it needs to create Data Catalog tables, databases, and partitions.
         *
         * For an example IAM policy that has the required permissions, see [Identity-based policy examples for Amazon AppFlow](https://docs.aws.amazon.com/appflow/latest/userguide/security_iam_id-based-policy-examples.html).
         */
        public var roleArn: kotlin.String? = null
        /**
         * A naming prefix for each Data Catalog table that Amazon AppFlow creates for the flow that you configure with this setting. Amazon AppFlow adds the prefix to the beginning of the each table name.
         */
        public var tablePrefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.GlueDataCatalogConfig) : this() {
            this.databaseName = x.databaseName
            this.roleArn = x.roleArn
            this.tablePrefix = x.tablePrefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.GlueDataCatalogConfig = GlueDataCatalogConfig(this)

        internal fun correctErrors(): Builder {
            if (databaseName == null) databaseName = ""
            if (roleArn == null) roleArn = ""
            if (tablePrefix == null) tablePrefix = ""
            return this
        }
    }
}
