// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.appflow.model.AppflowException
import aws.sdk.kotlin.services.appflow.model.ConnectorConfiguration
import aws.sdk.kotlin.services.appflow.model.ConnectorDetail
import aws.sdk.kotlin.services.appflow.model.DescribeConnectorsResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeConnectorsOperationDeserializer: HttpDeserialize<DescribeConnectorsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeConnectorsResponse {
        if (!response.status.isSuccess()) {
            throwDescribeConnectorsError(context, response)
        }
        val builder = DescribeConnectorsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeConnectorsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeConnectorsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AppflowException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AppflowException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeConnectorsOperationBody(builder: DescribeConnectorsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONNECTORCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("connectorConfigurations"))
    val CONNECTORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("connectors"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONNECTORCONFIGURATIONS_DESCRIPTOR)
        field(CONNECTORS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONNECTORCONFIGURATIONS_DESCRIPTOR.index -> builder.connectorConfigurations =
                    deserializer.deserializeMap(CONNECTORCONFIGURATIONS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, ConnectorConfiguration>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeConnectorConfigurationDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CONNECTORS_DESCRIPTOR.index -> builder.connectors =
                    deserializer.deserializeList(CONNECTORS_DESCRIPTOR) {
                        val col0 = mutableListOf<ConnectorDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeConnectorDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
