// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Specifies the configuration details of a schedule-triggered flow as defined by the user. Currently, these settings only apply to the `Scheduled` trigger type.
 */
public class ScheduledTriggerProperties private constructor(builder: Builder) {
    /**
     * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
     */
    public val dataPullMode: aws.sdk.kotlin.services.appflow.model.DataPullMode? = builder.dataPullMode
    /**
     * Specifies the date range for the records to import from the connector in the first flow run.
     */
    public val firstExecutionFrom: aws.smithy.kotlin.runtime.time.Instant? = builder.firstExecutionFrom
    /**
     * Defines how many times a scheduled flow fails consecutively before Amazon AppFlow deactivates it.
     */
    public val flowErrorDeactivationThreshold: kotlin.Int? = builder.flowErrorDeactivationThreshold
    /**
     * The time at which the scheduled flow ends. The time is formatted as a timestamp that follows the ISO 8601 standard, such as `2022-04-27T13:00:00-07:00`.
     */
    public val scheduleEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduleEndTime
    /**
     * The scheduling expression that determines the rate at which the schedule will run, for example `rate(5minutes)`.
     */
    public val scheduleExpression: kotlin.String? = builder.scheduleExpression
    /**
     * Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
     */
    public val scheduleOffset: kotlin.Long? = builder.scheduleOffset
    /**
     * The time at which the scheduled flow starts. The time is formatted as a timestamp that follows the ISO 8601 standard, such as `2022-04-26T13:00:00-07:00`.
     */
    public val scheduleStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.scheduleStartTime
    /**
     * Specifies the time zone used when referring to the dates and times of a scheduled flow, such as `America/New_York`. This time zone is only a descriptive label. It doesn't affect how Amazon AppFlow interprets the timestamps that you specify to schedule the flow.
     *
     * If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC offset in your timestamps. For example, the UTC offsets for the `America/New_York` timezone are `-04:00` EDT and `-05:00 EST`.
     */
    public val timezone: kotlin.String? = builder.timezone

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.ScheduledTriggerProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ScheduledTriggerProperties(")
        append("dataPullMode=$dataPullMode,")
        append("firstExecutionFrom=$firstExecutionFrom,")
        append("flowErrorDeactivationThreshold=$flowErrorDeactivationThreshold,")
        append("scheduleEndTime=$scheduleEndTime,")
        append("scheduleExpression=$scheduleExpression,")
        append("scheduleOffset=$scheduleOffset,")
        append("scheduleStartTime=$scheduleStartTime,")
        append("timezone=$timezone")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataPullMode?.hashCode() ?: 0
        result = 31 * result + (firstExecutionFrom?.hashCode() ?: 0)
        result = 31 * result + (flowErrorDeactivationThreshold ?: 0)
        result = 31 * result + (scheduleEndTime?.hashCode() ?: 0)
        result = 31 * result + (scheduleExpression?.hashCode() ?: 0)
        result = 31 * result + (scheduleOffset?.hashCode() ?: 0)
        result = 31 * result + (scheduleStartTime?.hashCode() ?: 0)
        result = 31 * result + (timezone?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ScheduledTriggerProperties

        if (dataPullMode != other.dataPullMode) return false
        if (firstExecutionFrom != other.firstExecutionFrom) return false
        if (flowErrorDeactivationThreshold != other.flowErrorDeactivationThreshold) return false
        if (scheduleEndTime != other.scheduleEndTime) return false
        if (scheduleExpression != other.scheduleExpression) return false
        if (scheduleOffset != other.scheduleOffset) return false
        if (scheduleStartTime != other.scheduleStartTime) return false
        if (timezone != other.timezone) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.ScheduledTriggerProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
         */
        public var dataPullMode: aws.sdk.kotlin.services.appflow.model.DataPullMode? = null
        /**
         * Specifies the date range for the records to import from the connector in the first flow run.
         */
        public var firstExecutionFrom: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Defines how many times a scheduled flow fails consecutively before Amazon AppFlow deactivates it.
         */
        public var flowErrorDeactivationThreshold: kotlin.Int? = null
        /**
         * The time at which the scheduled flow ends. The time is formatted as a timestamp that follows the ISO 8601 standard, such as `2022-04-27T13:00:00-07:00`.
         */
        public var scheduleEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The scheduling expression that determines the rate at which the schedule will run, for example `rate(5minutes)`.
         */
        public var scheduleExpression: kotlin.String? = null
        /**
         * Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
         */
        public var scheduleOffset: kotlin.Long? = null
        /**
         * The time at which the scheduled flow starts. The time is formatted as a timestamp that follows the ISO 8601 standard, such as `2022-04-26T13:00:00-07:00`.
         */
        public var scheduleStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the time zone used when referring to the dates and times of a scheduled flow, such as `America/New_York`. This time zone is only a descriptive label. It doesn't affect how Amazon AppFlow interprets the timestamps that you specify to schedule the flow.
         *
         * If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC offset in your timestamps. For example, the UTC offsets for the `America/New_York` timezone are `-04:00` EDT and `-05:00 EST`.
         */
        public var timezone: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.ScheduledTriggerProperties) : this() {
            this.dataPullMode = x.dataPullMode
            this.firstExecutionFrom = x.firstExecutionFrom
            this.flowErrorDeactivationThreshold = x.flowErrorDeactivationThreshold
            this.scheduleEndTime = x.scheduleEndTime
            this.scheduleExpression = x.scheduleExpression
            this.scheduleOffset = x.scheduleOffset
            this.scheduleStartTime = x.scheduleStartTime
            this.timezone = x.timezone
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.ScheduledTriggerProperties = ScheduledTriggerProperties(this)
    }
}
