// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * The properties that are applied when Salesforce is being used as a destination.
 */
public class SalesforceDestinationProperties private constructor(builder: Builder) {
    /**
     * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.
     *
     * ## AUTOMATIC
     * The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
     *
     * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
     *
     * By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
     *
     * ## BULKV2
     * Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.
     *
     * Note that Bulk API 2.0 does not transfer Salesforce compound fields.
     *
     * ## REST_SYNC
     * Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a timed out error.
     */
    public val dataTransferApi: aws.sdk.kotlin.services.appflow.model.SalesforceDataTransferApi? = builder.dataTransferApi
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
     */
    public val errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = builder.errorHandlingConfig
    /**
     * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or delete.
     */
    public val idFieldNames: List<String>? = builder.idFieldNames
    /**
     * The object specified in the Salesforce flow destination.
     */
    public val `object`: kotlin.String? = builder.`object`
    /**
     * This specifies the type of write operation to be performed in Salesforce. When the value is `UPSERT`, then `idFieldNames` is required.
     */
    public val writeOperationType: aws.sdk.kotlin.services.appflow.model.WriteOperationType? = builder.writeOperationType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.SalesforceDestinationProperties = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SalesforceDestinationProperties(")
        append("dataTransferApi=$dataTransferApi,")
        append("errorHandlingConfig=$errorHandlingConfig,")
        append("idFieldNames=$idFieldNames,")
        append("object=$`object`,")
        append("writeOperationType=$writeOperationType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataTransferApi?.hashCode() ?: 0
        result = 31 * result + (errorHandlingConfig?.hashCode() ?: 0)
        result = 31 * result + (idFieldNames?.hashCode() ?: 0)
        result = 31 * result + (`object`?.hashCode() ?: 0)
        result = 31 * result + (writeOperationType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SalesforceDestinationProperties

        if (dataTransferApi != other.dataTransferApi) return false
        if (errorHandlingConfig != other.errorHandlingConfig) return false
        if (idFieldNames != other.idFieldNames) return false
        if (`object` != other.`object`) return false
        if (writeOperationType != other.writeOperationType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.SalesforceDestinationProperties = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.
         *
         * ## AUTOMATIC
         * The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.
         *
         * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
         *
         * By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
         *
         * ## BULKV2
         * Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.
         *
         * Note that Bulk API 2.0 does not transfer Salesforce compound fields.
         *
         * ## REST_SYNC
         * Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a timed out error.
         */
        public var dataTransferApi: aws.sdk.kotlin.services.appflow.model.SalesforceDataTransferApi? = null
        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination. For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. `ErrorHandlingConfig` is a part of the destination connector details.
         */
        public var errorHandlingConfig: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig? = null
        /**
         * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or delete.
         */
        public var idFieldNames: List<String>? = null
        /**
         * The object specified in the Salesforce flow destination.
         */
        public var `object`: kotlin.String? = null
        /**
         * This specifies the type of write operation to be performed in Salesforce. When the value is `UPSERT`, then `idFieldNames` is required.
         */
        public var writeOperationType: aws.sdk.kotlin.services.appflow.model.WriteOperationType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.SalesforceDestinationProperties) : this() {
            this.dataTransferApi = x.dataTransferApi
            this.errorHandlingConfig = x.errorHandlingConfig
            this.idFieldNames = x.idFieldNames
            this.`object` = x.`object`
            this.writeOperationType = x.writeOperationType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.SalesforceDestinationProperties = SalesforceDestinationProperties(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig] inside the given [block]
         */
        public fun errorHandlingConfig(block: aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.Builder.() -> kotlin.Unit) {
            this.errorHandlingConfig = aws.sdk.kotlin.services.appflow.model.ErrorHandlingConfig.invoke(block)
        }
    }
}
