// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * Describes the metadata catalog, metadata table, and data partitions that Amazon AppFlow used for the associated flow run.
 */
public class MetadataCatalogDetail private constructor(builder: Builder) {
    /**
     * The type of metadata catalog that Amazon AppFlow used for the associated flow run. This parameter returns the following value:
     *
     * ## GLUE
     * The metadata catalog is provided by the Glue Data Catalog. Glue includes the Glue Data Catalog as a component.
     */
    public val catalogType: aws.sdk.kotlin.services.appflow.model.CatalogType? = builder.catalogType
    /**
     * Describes the status of the attempt from Amazon AppFlow to register the data partitions with the metadata catalog. The data partitions organize the flow output into a hierarchical path, such as a folder path in an S3 bucket. Amazon AppFlow creates the partitions (if they don't already exist) based on your flow configuration.
     */
    public val partitionRegistrationOutput: aws.sdk.kotlin.services.appflow.model.RegistrationOutput? = builder.partitionRegistrationOutput
    /**
     * The name of the table that stores the metadata for the associated flow run. The table stores metadata that represents the data that the flow transferred. Amazon AppFlow stores the table in the metadata catalog.
     */
    public val tableName: kotlin.String? = builder.tableName
    /**
     * Describes the status of the attempt from Amazon AppFlow to register the metadata table with the metadata catalog. Amazon AppFlow creates or updates this table for the associated flow run.
     */
    public val tableRegistrationOutput: aws.sdk.kotlin.services.appflow.model.RegistrationOutput? = builder.tableRegistrationOutput

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.MetadataCatalogDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MetadataCatalogDetail(")
        append("catalogType=$catalogType,")
        append("partitionRegistrationOutput=$partitionRegistrationOutput,")
        append("tableName=$tableName,")
        append("tableRegistrationOutput=$tableRegistrationOutput")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = catalogType?.hashCode() ?: 0
        result = 31 * result + (partitionRegistrationOutput?.hashCode() ?: 0)
        result = 31 * result + (tableName?.hashCode() ?: 0)
        result = 31 * result + (tableRegistrationOutput?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MetadataCatalogDetail

        if (catalogType != other.catalogType) return false
        if (partitionRegistrationOutput != other.partitionRegistrationOutput) return false
        if (tableName != other.tableName) return false
        if (tableRegistrationOutput != other.tableRegistrationOutput) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.MetadataCatalogDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of metadata catalog that Amazon AppFlow used for the associated flow run. This parameter returns the following value:
         *
         * ## GLUE
         * The metadata catalog is provided by the Glue Data Catalog. Glue includes the Glue Data Catalog as a component.
         */
        public var catalogType: aws.sdk.kotlin.services.appflow.model.CatalogType? = null
        /**
         * Describes the status of the attempt from Amazon AppFlow to register the data partitions with the metadata catalog. The data partitions organize the flow output into a hierarchical path, such as a folder path in an S3 bucket. Amazon AppFlow creates the partitions (if they don't already exist) based on your flow configuration.
         */
        public var partitionRegistrationOutput: aws.sdk.kotlin.services.appflow.model.RegistrationOutput? = null
        /**
         * The name of the table that stores the metadata for the associated flow run. The table stores metadata that represents the data that the flow transferred. Amazon AppFlow stores the table in the metadata catalog.
         */
        public var tableName: kotlin.String? = null
        /**
         * Describes the status of the attempt from Amazon AppFlow to register the metadata table with the metadata catalog. Amazon AppFlow creates or updates this table for the associated flow run.
         */
        public var tableRegistrationOutput: aws.sdk.kotlin.services.appflow.model.RegistrationOutput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.MetadataCatalogDetail) : this() {
            this.catalogType = x.catalogType
            this.partitionRegistrationOutput = x.partitionRegistrationOutput
            this.tableName = x.tableName
            this.tableRegistrationOutput = x.tableRegistrationOutput
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.MetadataCatalogDetail = MetadataCatalogDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.RegistrationOutput] inside the given [block]
         */
        public fun partitionRegistrationOutput(block: aws.sdk.kotlin.services.appflow.model.RegistrationOutput.Builder.() -> kotlin.Unit) {
            this.partitionRegistrationOutput = aws.sdk.kotlin.services.appflow.model.RegistrationOutput.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.RegistrationOutput] inside the given [block]
         */
        public fun tableRegistrationOutput(block: aws.sdk.kotlin.services.appflow.model.RegistrationOutput.Builder.() -> kotlin.Unit) {
            this.tableRegistrationOutput = aws.sdk.kotlin.services.appflow.model.RegistrationOutput.invoke(block)
        }
    }
}
