// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appflow.model



/**
 * Contains information about the configuration of destination connectors present in the flow.
 */
public class DestinationFlowConfig private constructor(builder: Builder) {
    /**
     * The API version that the destination connector uses.
     */
    public val apiVersion: kotlin.String? = builder.apiVersion
    /**
     * The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services account.
     */
    public val connectorProfileName: kotlin.String? = builder.connectorProfileName
    /**
     * The type of connector, such as Salesforce, Amplitude, and so on.
     */
    public val connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = builder.connectorType
    /**
     * This stores the information that is required to query a particular connector.
     */
    public val destinationConnectorProperties: aws.sdk.kotlin.services.appflow.model.DestinationConnectorProperties? = builder.destinationConnectorProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appflow.model.DestinationFlowConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DestinationFlowConfig(")
        append("apiVersion=$apiVersion,")
        append("connectorProfileName=$connectorProfileName,")
        append("connectorType=$connectorType,")
        append("destinationConnectorProperties=$destinationConnectorProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiVersion?.hashCode() ?: 0
        result = 31 * result + (connectorProfileName?.hashCode() ?: 0)
        result = 31 * result + (connectorType?.hashCode() ?: 0)
        result = 31 * result + (destinationConnectorProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DestinationFlowConfig

        if (apiVersion != other.apiVersion) return false
        if (connectorProfileName != other.connectorProfileName) return false
        if (connectorType != other.connectorType) return false
        if (destinationConnectorProperties != other.destinationConnectorProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appflow.model.DestinationFlowConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The API version that the destination connector uses.
         */
        public var apiVersion: kotlin.String? = null
        /**
         * The name of the connector profile. This name must be unique for each connector profile in the Amazon Web Services account.
         */
        public var connectorProfileName: kotlin.String? = null
        /**
         * The type of connector, such as Salesforce, Amplitude, and so on.
         */
        public var connectorType: aws.sdk.kotlin.services.appflow.model.ConnectorType? = null
        /**
         * This stores the information that is required to query a particular connector.
         */
        public var destinationConnectorProperties: aws.sdk.kotlin.services.appflow.model.DestinationConnectorProperties? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appflow.model.DestinationFlowConfig) : this() {
            this.apiVersion = x.apiVersion
            this.connectorProfileName = x.connectorProfileName
            this.connectorType = x.connectorType
            this.destinationConnectorProperties = x.destinationConnectorProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appflow.model.DestinationFlowConfig = DestinationFlowConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.appflow.model.DestinationConnectorProperties] inside the given [block]
         */
        public fun destinationConnectorProperties(block: aws.sdk.kotlin.services.appflow.model.DestinationConnectorProperties.Builder.() -> kotlin.Unit) {
            this.destinationConnectorProperties = aws.sdk.kotlin.services.appflow.model.DestinationConnectorProperties.invoke(block)
        }
    }
}
