// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.serde

import aws.sdk.kotlin.services.appfabric.model.Credential
import aws.sdk.kotlin.services.appfabric.model.Tenant
import aws.sdk.kotlin.services.appfabric.model.UpdateAppAuthorizationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateAppAuthorizationOperationSerializer: HttpSerializer.NonStreaming<UpdateAppAuthorizationRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateAppAuthorizationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.appBundleIdentifier) { "appBundleIdentifier is bound to the URI and must not be null" }
            requireNotNull(input.appAuthorizationIdentifier) { "appAuthorizationIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("appbundles"))
                add(PercentEncoding.SmithyLabel.encode(input.appBundleIdentifier))
                add(PercentEncoding.Path.encode("appauthorizations"))
                add(PercentEncoding.SmithyLabel.encode(input.appAuthorizationIdentifier))
            }
        }

        val payload = serializeUpdateAppAuthorizationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAppAuthorizationOperationBody(context: ExecutionContext, input: UpdateAppAuthorizationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CREDENTIAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("credential"))
    val TENANT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tenant"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREDENTIAL_DESCRIPTOR)
        field(TENANT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.credential?.let { field(CREDENTIAL_DESCRIPTOR, it, ::serializeCredentialDocument) }
        input.tenant?.let { field(TENANT_DESCRIPTOR, it, ::serializeTenantDocument) }
    }
    return serializer.toByteArray()
}
