// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an ingestion destination.
 */
public class IngestionDestination private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the ingestion destination.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The timestamp of when the ingestion destination was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * Contains information about the destination of ingested data.
     */
    public val destinationConfiguration: aws.sdk.kotlin.services.appfabric.model.DestinationConfiguration? = builder.destinationConfiguration
    /**
     * The Amazon Resource Name (ARN) of the ingestion.
     */
    public val ingestionArn: kotlin.String = requireNotNull(builder.ingestionArn) { "A non-null value must be provided for ingestionArn" }
    /**
     * Contains information about how ingested data is processed.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.appfabric.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * The state of the ingestion destination.
     *
     * The following states are possible:
     * + `Active`: The ingestion destination is active and is ready to be used.
     * + `Failed`: The ingestion destination has failed. If the ingestion destination is in this state, you should verify the ingestion destination configuration and try again.
     */
    public val status: aws.sdk.kotlin.services.appfabric.model.IngestionDestinationStatus? = builder.status
    /**
     * The reason for the current status of the ingestion destination.
     *
     * Only present when the `status` of ingestion destination is `Failed`.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The timestamp of when the ingestion destination was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.updatedAt

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appfabric.model.IngestionDestination = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("IngestionDestination(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("destinationConfiguration=$destinationConfiguration,")
        append("ingestionArn=$ingestionArn,")
        append("processingConfiguration=$processingConfiguration,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn.hashCode()
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (destinationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ingestionArn.hashCode())
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (updatedAt?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as IngestionDestination

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (destinationConfiguration != other.destinationConfiguration) return false
        if (ingestionArn != other.ingestionArn) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appfabric.model.IngestionDestination = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the ingestion destination.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp of when the ingestion destination was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Contains information about the destination of ingested data.
         */
        public var destinationConfiguration: aws.sdk.kotlin.services.appfabric.model.DestinationConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) of the ingestion.
         */
        public var ingestionArn: kotlin.String? = null
        /**
         * Contains information about how ingested data is processed.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.appfabric.model.ProcessingConfiguration? = null
        /**
         * The state of the ingestion destination.
         *
         * The following states are possible:
         * + `Active`: The ingestion destination is active and is ready to be used.
         * + `Failed`: The ingestion destination has failed. If the ingestion destination is in this state, you should verify the ingestion destination configuration and try again.
         */
        public var status: aws.sdk.kotlin.services.appfabric.model.IngestionDestinationStatus? = null
        /**
         * The reason for the current status of the ingestion destination.
         *
         * Only present when the `status` of ingestion destination is `Failed`.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The timestamp of when the ingestion destination was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appfabric.model.IngestionDestination) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.destinationConfiguration = x.destinationConfiguration
            this.ingestionArn = x.ingestionArn
            this.processingConfiguration = x.processingConfiguration
            this.status = x.status
            this.statusReason = x.statusReason
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appfabric.model.IngestionDestination = IngestionDestination(this)

        internal fun correctErrors(): Builder {
            if (arn == null) arn = ""
            if (ingestionArn == null) ingestionArn = ""
            return this
        }
    }
}
