// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.serde

import aws.sdk.kotlin.services.appfabric.model.CreateIngestionRequest
import aws.sdk.kotlin.services.appfabric.model.IngestionType
import aws.sdk.kotlin.services.appfabric.model.Tag
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateIngestionOperationSerializer: HttpSerializer.NonStreaming<CreateIngestionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateIngestionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.appBundleIdentifier) { "appBundleIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("appbundles"))
                add(PercentEncoding.SmithyLabel.encode(input.appBundleIdentifier))
                add(PercentEncoding.Path.encode("ingestions"))
            }
        }

        val payload = serializeCreateIngestionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateIngestionOperationBody(context: ExecutionContext, input: CreateIngestionRequest): ByteArray {
    val serializer = JsonSerializer()
    val APP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("app"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val INGESTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("ingestionType"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val TENANTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tenantId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APP_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(INGESTIONTYPE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TENANTID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.app?.let { field(APP_DESCRIPTOR, it) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.ingestionType?.let { field(INGESTIONTYPE_DESCRIPTOR, it.value) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.tenantId?.let { field(TENANTID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
