// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.appfabric.auth.AppFabricAuthSchemeProvider
import aws.sdk.kotlin.services.appfabric.auth.DefaultAppFabricAuthSchemeProvider
import aws.sdk.kotlin.services.appfabric.endpoints.AppFabricEndpointParameters
import aws.sdk.kotlin.services.appfabric.endpoints.AppFabricEndpointProvider
import aws.sdk.kotlin.services.appfabric.endpoints.DefaultAppFabricEndpointProvider
import aws.sdk.kotlin.services.appfabric.model.BatchGetUserAccessTasksRequest
import aws.sdk.kotlin.services.appfabric.model.BatchGetUserAccessTasksResponse
import aws.sdk.kotlin.services.appfabric.model.ConnectAppAuthorizationRequest
import aws.sdk.kotlin.services.appfabric.model.ConnectAppAuthorizationResponse
import aws.sdk.kotlin.services.appfabric.model.CreateAppAuthorizationRequest
import aws.sdk.kotlin.services.appfabric.model.CreateAppAuthorizationResponse
import aws.sdk.kotlin.services.appfabric.model.CreateAppBundleRequest
import aws.sdk.kotlin.services.appfabric.model.CreateAppBundleResponse
import aws.sdk.kotlin.services.appfabric.model.CreateIngestionDestinationRequest
import aws.sdk.kotlin.services.appfabric.model.CreateIngestionDestinationResponse
import aws.sdk.kotlin.services.appfabric.model.CreateIngestionRequest
import aws.sdk.kotlin.services.appfabric.model.CreateIngestionResponse
import aws.sdk.kotlin.services.appfabric.model.DeleteAppAuthorizationRequest
import aws.sdk.kotlin.services.appfabric.model.DeleteAppAuthorizationResponse
import aws.sdk.kotlin.services.appfabric.model.DeleteAppBundleRequest
import aws.sdk.kotlin.services.appfabric.model.DeleteAppBundleResponse
import aws.sdk.kotlin.services.appfabric.model.DeleteIngestionDestinationRequest
import aws.sdk.kotlin.services.appfabric.model.DeleteIngestionDestinationResponse
import aws.sdk.kotlin.services.appfabric.model.DeleteIngestionRequest
import aws.sdk.kotlin.services.appfabric.model.DeleteIngestionResponse
import aws.sdk.kotlin.services.appfabric.model.GetAppAuthorizationRequest
import aws.sdk.kotlin.services.appfabric.model.GetAppAuthorizationResponse
import aws.sdk.kotlin.services.appfabric.model.GetAppBundleRequest
import aws.sdk.kotlin.services.appfabric.model.GetAppBundleResponse
import aws.sdk.kotlin.services.appfabric.model.GetIngestionDestinationRequest
import aws.sdk.kotlin.services.appfabric.model.GetIngestionDestinationResponse
import aws.sdk.kotlin.services.appfabric.model.GetIngestionRequest
import aws.sdk.kotlin.services.appfabric.model.GetIngestionResponse
import aws.sdk.kotlin.services.appfabric.model.ListAppAuthorizationsRequest
import aws.sdk.kotlin.services.appfabric.model.ListAppAuthorizationsResponse
import aws.sdk.kotlin.services.appfabric.model.ListAppBundlesRequest
import aws.sdk.kotlin.services.appfabric.model.ListAppBundlesResponse
import aws.sdk.kotlin.services.appfabric.model.ListIngestionDestinationsRequest
import aws.sdk.kotlin.services.appfabric.model.ListIngestionDestinationsResponse
import aws.sdk.kotlin.services.appfabric.model.ListIngestionsRequest
import aws.sdk.kotlin.services.appfabric.model.ListIngestionsResponse
import aws.sdk.kotlin.services.appfabric.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.appfabric.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.appfabric.model.StartIngestionRequest
import aws.sdk.kotlin.services.appfabric.model.StartIngestionResponse
import aws.sdk.kotlin.services.appfabric.model.StartUserAccessTasksRequest
import aws.sdk.kotlin.services.appfabric.model.StartUserAccessTasksResponse
import aws.sdk.kotlin.services.appfabric.model.StopIngestionRequest
import aws.sdk.kotlin.services.appfabric.model.StopIngestionResponse
import aws.sdk.kotlin.services.appfabric.model.TagResourceRequest
import aws.sdk.kotlin.services.appfabric.model.TagResourceResponse
import aws.sdk.kotlin.services.appfabric.model.UntagResourceRequest
import aws.sdk.kotlin.services.appfabric.model.UntagResourceResponse
import aws.sdk.kotlin.services.appfabric.model.UpdateAppAuthorizationRequest
import aws.sdk.kotlin.services.appfabric.model.UpdateAppAuthorizationResponse
import aws.sdk.kotlin.services.appfabric.model.UpdateIngestionDestinationRequest
import aws.sdk.kotlin.services.appfabric.model.UpdateIngestionDestinationResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "AppFabric"
public const val SdkVersion: String = "1.2.52"
public const val ServiceApiVersion: String = "2023-05-19"

/**
 * Amazon Web Services AppFabric quickly connects software as a service (SaaS) applications across your organization. This allows IT and security teams to easily manage and secure applications using a standard schema, and employees can complete everyday tasks faster using generative artificial intelligence (AI). You can use these APIs to complete AppFabric tasks, such as setting up audit log ingestions or viewing user access. For more information about AppFabric, including the required permissions to use the service, see the [Amazon Web Services AppFabric Administration Guide](https://docs.aws.amazon.com/appfabric/latest/adminguide/). For more information about using the Command Line Interface (CLI) to manage your AppFabric resources, see the [AppFabric section of the CLI Reference](https://docs.aws.amazon.com/cli/latest/reference/appfabric/index.html).
 */
public interface AppFabricClient : SdkClient {
    /**
     * AppFabricClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, AppFabricClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "AppFabric",
                "APPFABRIC",
                "appfabric",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, AppFabricClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): AppFabricClient = DefaultAppFabricClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: AppFabricEndpointProvider = builder.endpointProvider ?: DefaultAppFabricEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: AppFabricAuthSchemeProvider = builder.authSchemeProvider ?: DefaultAppFabricAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "AppFabric"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: AppFabricEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: AppFabricAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Gets user access details in a batch request.
     *
     * This action polls data from the tasks that are kicked off by the `StartUserAccessTasks` action.
     */
    public suspend fun batchGetUserAccessTasks(input: BatchGetUserAccessTasksRequest): BatchGetUserAccessTasksResponse

    /**
     * Establishes a connection between Amazon Web Services AppFabric and an application, which allows AppFabric to call the APIs of the application.
     */
    public suspend fun connectAppAuthorization(input: ConnectAppAuthorizationRequest): ConnectAppAuthorizationResponse

    /**
     * Creates an app authorization within an app bundle, which allows AppFabric to connect to an application.
     */
    public suspend fun createAppAuthorization(input: CreateAppAuthorizationRequest): CreateAppAuthorizationResponse

    /**
     * Creates an app bundle to collect data from an application using AppFabric.
     */
    public suspend fun createAppBundle(input: CreateAppBundleRequest = CreateAppBundleRequest { }): CreateAppBundleResponse

    /**
     * Creates a data ingestion for an application.
     */
    public suspend fun createIngestion(input: CreateIngestionRequest): CreateIngestionResponse

    /**
     * Creates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web Services AppFabric and where it's delivered.
     */
    public suspend fun createIngestionDestination(input: CreateIngestionDestinationRequest): CreateIngestionDestinationResponse

    /**
     * Deletes an app authorization. You must delete the associated ingestion before you can delete an app authorization.
     */
    public suspend fun deleteAppAuthorization(input: DeleteAppAuthorizationRequest): DeleteAppAuthorizationResponse

    /**
     * Deletes an app bundle. You must delete all associated app authorizations before you can delete an app bundle.
     */
    public suspend fun deleteAppBundle(input: DeleteAppBundleRequest): DeleteAppBundleResponse

    /**
     * Deletes an ingestion. You must stop (disable) the ingestion and you must delete all associated ingestion destinations before you can delete an app ingestion.
     */
    public suspend fun deleteIngestion(input: DeleteIngestionRequest): DeleteIngestionResponse

    /**
     * Deletes an ingestion destination.
     *
     * This deletes the association between an ingestion and it's destination. It doesn't delete previously ingested data or the storage destination, such as the Amazon S3 bucket where the data is delivered. If the ingestion destination is deleted while the associated ingestion is enabled, the ingestion will fail and is eventually disabled.
     */
    public suspend fun deleteIngestionDestination(input: DeleteIngestionDestinationRequest): DeleteIngestionDestinationResponse

    /**
     * Returns information about an app authorization.
     */
    public suspend fun getAppAuthorization(input: GetAppAuthorizationRequest): GetAppAuthorizationResponse

    /**
     * Returns information about an app bundle.
     */
    public suspend fun getAppBundle(input: GetAppBundleRequest): GetAppBundleResponse

    /**
     * Returns information about an ingestion.
     */
    public suspend fun getIngestion(input: GetIngestionRequest): GetIngestionResponse

    /**
     * Returns information about an ingestion destination.
     */
    public suspend fun getIngestionDestination(input: GetIngestionDestinationRequest): GetIngestionDestinationResponse

    /**
     * Returns a list of all app authorizations configured for an app bundle.
     */
    public suspend fun listAppAuthorizations(input: ListAppAuthorizationsRequest): ListAppAuthorizationsResponse

    /**
     * Returns a list of app bundles.
     */
    public suspend fun listAppBundles(input: ListAppBundlesRequest = ListAppBundlesRequest { }): ListAppBundlesResponse

    /**
     * Returns a list of all ingestion destinations configured for an ingestion.
     */
    public suspend fun listIngestionDestinations(input: ListIngestionDestinationsRequest): ListIngestionDestinationsResponse

    /**
     * Returns a list of all ingestions configured for an app bundle.
     */
    public suspend fun listIngestions(input: ListIngestionsRequest): ListIngestionsResponse

    /**
     * Returns a list of tags for a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Starts (enables) an ingestion, which collects data from an application.
     */
    public suspend fun startIngestion(input: StartIngestionRequest): StartIngestionResponse

    /**
     * Starts the tasks to search user access status for a specific email address.
     *
     * The tasks are stopped when the user access status data is found. The tasks are terminated when the API calls to the application time out.
     */
    public suspend fun startUserAccessTasks(input: StartUserAccessTasksRequest): StartUserAccessTasksResponse

    /**
     * Stops (disables) an ingestion.
     */
    public suspend fun stopIngestion(input: StopIngestionRequest): StopIngestionResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag or tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an app authorization within an app bundle, which allows AppFabric to connect to an application.
     *
     * If the app authorization was in a `connected` state, updating the app authorization will set it back to a `PendingConnect` state.
     */
    public suspend fun updateAppAuthorization(input: UpdateAppAuthorizationRequest): UpdateAppAuthorizationResponse

    /**
     * Updates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web Services AppFabric and where it's delivered.
     */
    public suspend fun updateIngestionDestination(input: UpdateIngestionDestinationRequest): UpdateIngestionDestinationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun AppFabricClient.withConfig(block: AppFabricClient.Config.Builder.() -> Unit): AppFabricClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultAppFabricClient(newConfig)
}

/**
 * Gets user access details in a batch request.
 *
 * This action polls data from the tasks that are kicked off by the `StartUserAccessTasks` action.
 */
public suspend inline fun AppFabricClient.batchGetUserAccessTasks(crossinline block: BatchGetUserAccessTasksRequest.Builder.() -> Unit): BatchGetUserAccessTasksResponse = batchGetUserAccessTasks(BatchGetUserAccessTasksRequest.Builder().apply(block).build())

/**
 * Establishes a connection between Amazon Web Services AppFabric and an application, which allows AppFabric to call the APIs of the application.
 */
public suspend inline fun AppFabricClient.connectAppAuthorization(crossinline block: ConnectAppAuthorizationRequest.Builder.() -> Unit): ConnectAppAuthorizationResponse = connectAppAuthorization(ConnectAppAuthorizationRequest.Builder().apply(block).build())

/**
 * Creates an app authorization within an app bundle, which allows AppFabric to connect to an application.
 */
public suspend inline fun AppFabricClient.createAppAuthorization(crossinline block: CreateAppAuthorizationRequest.Builder.() -> Unit): CreateAppAuthorizationResponse = createAppAuthorization(CreateAppAuthorizationRequest.Builder().apply(block).build())

/**
 * Creates an app bundle to collect data from an application using AppFabric.
 */
public suspend inline fun AppFabricClient.createAppBundle(crossinline block: CreateAppBundleRequest.Builder.() -> Unit): CreateAppBundleResponse = createAppBundle(CreateAppBundleRequest.Builder().apply(block).build())

/**
 * Creates a data ingestion for an application.
 */
public suspend inline fun AppFabricClient.createIngestion(crossinline block: CreateIngestionRequest.Builder.() -> Unit): CreateIngestionResponse = createIngestion(CreateIngestionRequest.Builder().apply(block).build())

/**
 * Creates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web Services AppFabric and where it's delivered.
 */
public suspend inline fun AppFabricClient.createIngestionDestination(crossinline block: CreateIngestionDestinationRequest.Builder.() -> Unit): CreateIngestionDestinationResponse = createIngestionDestination(CreateIngestionDestinationRequest.Builder().apply(block).build())

/**
 * Deletes an app authorization. You must delete the associated ingestion before you can delete an app authorization.
 */
public suspend inline fun AppFabricClient.deleteAppAuthorization(crossinline block: DeleteAppAuthorizationRequest.Builder.() -> Unit): DeleteAppAuthorizationResponse = deleteAppAuthorization(DeleteAppAuthorizationRequest.Builder().apply(block).build())

/**
 * Deletes an app bundle. You must delete all associated app authorizations before you can delete an app bundle.
 */
public suspend inline fun AppFabricClient.deleteAppBundle(crossinline block: DeleteAppBundleRequest.Builder.() -> Unit): DeleteAppBundleResponse = deleteAppBundle(DeleteAppBundleRequest.Builder().apply(block).build())

/**
 * Deletes an ingestion. You must stop (disable) the ingestion and you must delete all associated ingestion destinations before you can delete an app ingestion.
 */
public suspend inline fun AppFabricClient.deleteIngestion(crossinline block: DeleteIngestionRequest.Builder.() -> Unit): DeleteIngestionResponse = deleteIngestion(DeleteIngestionRequest.Builder().apply(block).build())

/**
 * Deletes an ingestion destination.
 *
 * This deletes the association between an ingestion and it's destination. It doesn't delete previously ingested data or the storage destination, such as the Amazon S3 bucket where the data is delivered. If the ingestion destination is deleted while the associated ingestion is enabled, the ingestion will fail and is eventually disabled.
 */
public suspend inline fun AppFabricClient.deleteIngestionDestination(crossinline block: DeleteIngestionDestinationRequest.Builder.() -> Unit): DeleteIngestionDestinationResponse = deleteIngestionDestination(DeleteIngestionDestinationRequest.Builder().apply(block).build())

/**
 * Returns information about an app authorization.
 */
public suspend inline fun AppFabricClient.getAppAuthorization(crossinline block: GetAppAuthorizationRequest.Builder.() -> Unit): GetAppAuthorizationResponse = getAppAuthorization(GetAppAuthorizationRequest.Builder().apply(block).build())

/**
 * Returns information about an app bundle.
 */
public suspend inline fun AppFabricClient.getAppBundle(crossinline block: GetAppBundleRequest.Builder.() -> Unit): GetAppBundleResponse = getAppBundle(GetAppBundleRequest.Builder().apply(block).build())

/**
 * Returns information about an ingestion.
 */
public suspend inline fun AppFabricClient.getIngestion(crossinline block: GetIngestionRequest.Builder.() -> Unit): GetIngestionResponse = getIngestion(GetIngestionRequest.Builder().apply(block).build())

/**
 * Returns information about an ingestion destination.
 */
public suspend inline fun AppFabricClient.getIngestionDestination(crossinline block: GetIngestionDestinationRequest.Builder.() -> Unit): GetIngestionDestinationResponse = getIngestionDestination(GetIngestionDestinationRequest.Builder().apply(block).build())

/**
 * Returns a list of all app authorizations configured for an app bundle.
 */
public suspend inline fun AppFabricClient.listAppAuthorizations(crossinline block: ListAppAuthorizationsRequest.Builder.() -> Unit): ListAppAuthorizationsResponse = listAppAuthorizations(ListAppAuthorizationsRequest.Builder().apply(block).build())

/**
 * Returns a list of app bundles.
 */
public suspend inline fun AppFabricClient.listAppBundles(crossinline block: ListAppBundlesRequest.Builder.() -> Unit): ListAppBundlesResponse = listAppBundles(ListAppBundlesRequest.Builder().apply(block).build())

/**
 * Returns a list of all ingestion destinations configured for an ingestion.
 */
public suspend inline fun AppFabricClient.listIngestionDestinations(crossinline block: ListIngestionDestinationsRequest.Builder.() -> Unit): ListIngestionDestinationsResponse = listIngestionDestinations(ListIngestionDestinationsRequest.Builder().apply(block).build())

/**
 * Returns a list of all ingestions configured for an app bundle.
 */
public suspend inline fun AppFabricClient.listIngestions(crossinline block: ListIngestionsRequest.Builder.() -> Unit): ListIngestionsResponse = listIngestions(ListIngestionsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags for a resource.
 */
public suspend inline fun AppFabricClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Starts (enables) an ingestion, which collects data from an application.
 */
public suspend inline fun AppFabricClient.startIngestion(crossinline block: StartIngestionRequest.Builder.() -> Unit): StartIngestionResponse = startIngestion(StartIngestionRequest.Builder().apply(block).build())

/**
 * Starts the tasks to search user access status for a specific email address.
 *
 * The tasks are stopped when the user access status data is found. The tasks are terminated when the API calls to the application time out.
 */
public suspend inline fun AppFabricClient.startUserAccessTasks(crossinline block: StartUserAccessTasksRequest.Builder.() -> Unit): StartUserAccessTasksResponse = startUserAccessTasks(StartUserAccessTasksRequest.Builder().apply(block).build())

/**
 * Stops (disables) an ingestion.
 */
public suspend inline fun AppFabricClient.stopIngestion(crossinline block: StopIngestionRequest.Builder.() -> Unit): StopIngestionResponse = stopIngestion(StopIngestionRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified resource.
 */
public suspend inline fun AppFabricClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag or tags from a resource.
 */
public suspend inline fun AppFabricClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an app authorization within an app bundle, which allows AppFabric to connect to an application.
 *
 * If the app authorization was in a `connected` state, updating the app authorization will set it back to a `PendingConnect` state.
 */
public suspend inline fun AppFabricClient.updateAppAuthorization(crossinline block: UpdateAppAuthorizationRequest.Builder.() -> Unit): UpdateAppAuthorizationResponse = updateAppAuthorization(UpdateAppAuthorizationRequest.Builder().apply(block).build())

/**
 * Updates an ingestion destination, which specifies how an application's ingested data is processed by Amazon Web Services AppFabric and where it's delivered.
 */
public suspend inline fun AppFabricClient.updateIngestionDestination(crossinline block: UpdateIngestionDestinationRequest.Builder.() -> Unit): UpdateIngestionDestinationResponse = updateIngestionDestination(UpdateIngestionDestinationRequest.Builder().apply(block).build())
