// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateAppAuthorizationRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
     */
    public val appAuthorizationIdentifier: kotlin.String? = builder.appAuthorizationIdentifier
    /**
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     */
    public val appBundleIdentifier: kotlin.String? = builder.appBundleIdentifier
    /**
     * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
     *
     * Specify credentials that match the authorization type of the app authorization to update. For example, if the authorization type of the app authorization is OAuth2 (`oauth2`), then you should provide only the OAuth2 credentials.
     */
    public val credential: aws.sdk.kotlin.services.appfabric.model.Credential? = builder.credential
    /**
     * Contains information about an application tenant, such as the application display name and identifier.
     */
    public val tenant: aws.sdk.kotlin.services.appfabric.model.Tenant? = builder.tenant

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appfabric.model.UpdateAppAuthorizationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAppAuthorizationRequest(")
        append("appAuthorizationIdentifier=$appAuthorizationIdentifier,")
        append("appBundleIdentifier=$appBundleIdentifier,")
        append("credential=$credential,")
        append("tenant=$tenant")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appAuthorizationIdentifier?.hashCode() ?: 0
        result = 31 * result + (appBundleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (credential?.hashCode() ?: 0)
        result = 31 * result + (tenant?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAppAuthorizationRequest

        if (appAuthorizationIdentifier != other.appAuthorizationIdentifier) return false
        if (appBundleIdentifier != other.appBundleIdentifier) return false
        if (credential != other.credential) return false
        if (tenant != other.tenant) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appfabric.model.UpdateAppAuthorizationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app authorization to use for the request.
         */
        public var appAuthorizationIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
         */
        public var appBundleIdentifier: kotlin.String? = null
        /**
         * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
         *
         * Specify credentials that match the authorization type of the app authorization to update. For example, if the authorization type of the app authorization is OAuth2 (`oauth2`), then you should provide only the OAuth2 credentials.
         */
        public var credential: aws.sdk.kotlin.services.appfabric.model.Credential? = null
        /**
         * Contains information about an application tenant, such as the application display name and identifier.
         */
        public var tenant: aws.sdk.kotlin.services.appfabric.model.Tenant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appfabric.model.UpdateAppAuthorizationRequest) : this() {
            this.appAuthorizationIdentifier = x.appAuthorizationIdentifier
            this.appBundleIdentifier = x.appBundleIdentifier
            this.credential = x.credential
            this.tenant = x.tenant
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appfabric.model.UpdateAppAuthorizationRequest = UpdateAppAuthorizationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appfabric.model.Tenant] inside the given [block]
         */
        public fun tenant(block: aws.sdk.kotlin.services.appfabric.model.Tenant.Builder.() -> kotlin.Unit) {
            this.tenant = aws.sdk.kotlin.services.appfabric.model.Tenant.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
