// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAppAuthorizationRequest private constructor(builder: Builder) {
    /**
     * The name of the application.
     *
     * Valid values are:
     * + `SLACK`
     * + `ASANA`
     * + `JIRA`
     * + `M365`
     * + `M365AUDITLOGS`
     * + `ZOOM`
     * + `ZENDESK`
     * + `OKTA`
     * + `GOOGLE`
     * + `DROPBOX`
     * + `SMARTSHEET`
     * + `CISCO`
     */
    public val app: kotlin.String? = builder.app
    /**
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     */
    public val appBundleIdentifier: kotlin.String? = builder.appBundleIdentifier
    /**
     * The authorization type for the app authorization.
     */
    public val authType: aws.sdk.kotlin.services.appfabric.model.AuthType? = builder.authType
    /**
     * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value](https://wikipedia.org/wiki/Universally_unique_identifier).
     *
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     *
     * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `IdempotentParameterMismatch` error.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
     *
     * Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (`oauth2`), then you should provide only the OAuth2 credentials.
     */
    public val credential: aws.sdk.kotlin.services.appfabric.model.Credential? = builder.credential
    /**
     * A map of the key-value pairs of the tag or tags to assign to the resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * Contains information about an application tenant, such as the application display name and identifier.
     */
    public val tenant: aws.sdk.kotlin.services.appfabric.model.Tenant? = builder.tenant

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appfabric.model.CreateAppAuthorizationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAppAuthorizationRequest(")
        append("app=$app,")
        append("appBundleIdentifier=$appBundleIdentifier,")
        append("authType=$authType,")
        append("clientToken=$clientToken,")
        append("credential=$credential,")
        append("tags=$tags,")
        append("tenant=$tenant")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = app?.hashCode() ?: 0
        result = 31 * result + (appBundleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (authType?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (credential?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tenant?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAppAuthorizationRequest

        if (app != other.app) return false
        if (appBundleIdentifier != other.appBundleIdentifier) return false
        if (authType != other.authType) return false
        if (clientToken != other.clientToken) return false
        if (credential != other.credential) return false
        if (tags != other.tags) return false
        if (tenant != other.tenant) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appfabric.model.CreateAppAuthorizationRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the application.
         *
         * Valid values are:
         * + `SLACK`
         * + `ASANA`
         * + `JIRA`
         * + `M365`
         * + `M365AUDITLOGS`
         * + `ZOOM`
         * + `ZENDESK`
         * + `OKTA`
         * + `GOOGLE`
         * + `DROPBOX`
         * + `SMARTSHEET`
         * + `CISCO`
         */
        public var app: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
         */
        public var appBundleIdentifier: kotlin.String? = null
        /**
         * The authorization type for the app authorization.
         */
        public var authType: aws.sdk.kotlin.services.appfabric.model.AuthType? = null
        /**
         * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value](https://wikipedia.org/wiki/Universally_unique_identifier).
         *
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         *
         * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `IdempotentParameterMismatch` error.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Contains credentials for the application, such as an API key or OAuth2 client ID and secret.
         *
         * Specify credentials that match the authorization type for your request. For example, if the authorization type for your request is OAuth2 (`oauth2`), then you should provide only the OAuth2 credentials.
         */
        public var credential: aws.sdk.kotlin.services.appfabric.model.Credential? = null
        /**
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         */
        public var tags: List<Tag>? = null
        /**
         * Contains information about an application tenant, such as the application display name and identifier.
         */
        public var tenant: aws.sdk.kotlin.services.appfabric.model.Tenant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appfabric.model.CreateAppAuthorizationRequest) : this() {
            this.app = x.app
            this.appBundleIdentifier = x.appBundleIdentifier
            this.authType = x.authType
            this.clientToken = x.clientToken
            this.credential = x.credential
            this.tags = x.tags
            this.tenant = x.tenant
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appfabric.model.CreateAppAuthorizationRequest = CreateAppAuthorizationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.appfabric.model.Tenant] inside the given [block]
         */
        public fun tenant(block: aws.sdk.kotlin.services.appfabric.model.Tenant.Builder.() -> kotlin.Unit) {
            this.tenant = aws.sdk.kotlin.services.appfabric.model.Tenant.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
