// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.paginators

import aws.sdk.kotlin.services.appfabric.AppFabricClient
import aws.sdk.kotlin.services.appfabric.model.AppAuthorizationSummary
import aws.sdk.kotlin.services.appfabric.model.AppBundleSummary
import aws.sdk.kotlin.services.appfabric.model.IngestionDestinationSummary
import aws.sdk.kotlin.services.appfabric.model.IngestionSummary
import aws.sdk.kotlin.services.appfabric.model.ListAppAuthorizationsRequest
import aws.sdk.kotlin.services.appfabric.model.ListAppAuthorizationsResponse
import aws.sdk.kotlin.services.appfabric.model.ListAppBundlesRequest
import aws.sdk.kotlin.services.appfabric.model.ListAppBundlesResponse
import aws.sdk.kotlin.services.appfabric.model.ListIngestionDestinationsRequest
import aws.sdk.kotlin.services.appfabric.model.ListIngestionDestinationsResponse
import aws.sdk.kotlin.services.appfabric.model.ListIngestionsRequest
import aws.sdk.kotlin.services.appfabric.model.ListIngestionsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAppAuthorizationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppAuthorizationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppAuthorizationsResponse]
 */
public fun AppFabricClient.listAppAuthorizationsPaginated(initialRequest: ListAppAuthorizationsRequest): Flow<ListAppAuthorizationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppAuthorizationsPaginated.listAppAuthorizations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAppAuthorizationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppAuthorizationsResponse]
 */
public fun AppFabricClient.listAppAuthorizationsPaginated(block: ListAppAuthorizationsRequest.Builder.() -> Unit): Flow<ListAppAuthorizationsResponse> =
    listAppAuthorizationsPaginated(ListAppAuthorizationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAppAuthorizationsPaginated]
 * to access the nested member [AppAuthorizationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AppAuthorizationSummary]
 */
@JvmName("listAppAuthorizationsResponseAppAuthorizationSummary")
public fun Flow<ListAppAuthorizationsResponse>.appAuthorizationSummaryList(): Flow<AppAuthorizationSummary> =
    transform() { response ->
        response.appAuthorizationSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListAppBundlesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppBundlesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppBundlesResponse]
 */
public fun AppFabricClient.listAppBundlesPaginated(initialRequest: ListAppBundlesRequest = ListAppBundlesRequest { }): Flow<ListAppBundlesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppBundlesPaginated.listAppBundles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAppBundlesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppBundlesResponse]
 */
public fun AppFabricClient.listAppBundlesPaginated(block: ListAppBundlesRequest.Builder.() -> Unit): Flow<ListAppBundlesResponse> =
    listAppBundlesPaginated(ListAppBundlesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAppBundlesPaginated]
 * to access the nested member [AppBundleSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [AppBundleSummary]
 */
@JvmName("listAppBundlesResponseAppBundleSummary")
public fun Flow<ListAppBundlesResponse>.appBundleSummaryList(): Flow<AppBundleSummary> =
    transform() { response ->
        response.appBundleSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIngestionDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIngestionDestinationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIngestionDestinationsResponse]
 */
public fun AppFabricClient.listIngestionDestinationsPaginated(initialRequest: ListIngestionDestinationsRequest): Flow<ListIngestionDestinationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIngestionDestinationsPaginated.listIngestionDestinations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIngestionDestinationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIngestionDestinationsResponse]
 */
public fun AppFabricClient.listIngestionDestinationsPaginated(block: ListIngestionDestinationsRequest.Builder.() -> Unit): Flow<ListIngestionDestinationsResponse> =
    listIngestionDestinationsPaginated(ListIngestionDestinationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIngestionDestinationsPaginated]
 * to access the nested member [IngestionDestinationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IngestionDestinationSummary]
 */
@JvmName("listIngestionDestinationsResponseIngestionDestinationSummary")
public fun Flow<ListIngestionDestinationsResponse>.ingestionDestinations(): Flow<IngestionDestinationSummary> =
    transform() { response ->
        response.ingestionDestinations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListIngestionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListIngestionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIngestionsResponse]
 */
public fun AppFabricClient.listIngestionsPaginated(initialRequest: ListIngestionsRequest): Flow<ListIngestionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listIngestionsPaginated.listIngestions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListIngestionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListIngestionsResponse]
 */
public fun AppFabricClient.listIngestionsPaginated(block: ListIngestionsRequest.Builder.() -> Unit): Flow<ListIngestionsResponse> =
    listIngestionsPaginated(ListIngestionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listIngestionsPaginated]
 * to access the nested member [IngestionSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [IngestionSummary]
 */
@JvmName("listIngestionsResponseIngestionSummary")
public fun Flow<ListIngestionsResponse>.ingestions(): Flow<IngestionSummary> =
    transform() { response ->
        response.ingestions?.forEach {
            emit(it)
        }
    }
