// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateIngestionRequest private constructor(builder: Builder) {
    /**
     * The name of the application.
     *
     * Valid values are:
     * + `SLACK`
     * + `ASANA`
     * + `JIRA`
     * + `M365`
     * + `M365AUDITLOGS`
     * + `ZOOM`
     * + `ZENDESK`
     * + `OKTA`
     * + `GOOGLE`
     * + `DROPBOX`
     * + `SMARTSHEET`
     * + `CISCO`
     */
    public val app: kotlin.String? = builder.app
    /**
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     */
    public val appBundleIdentifier: kotlin.String? = builder.appBundleIdentifier
    /**
     * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value](https://wikipedia.org/wiki/Universally_unique_identifier).
     *
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     *
     * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `IdempotentParameterMismatch` error.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The ingestion type.
     */
    public val ingestionType: aws.sdk.kotlin.services.appfabric.model.IngestionType? = builder.ingestionType
    /**
     * A map of the key-value pairs of the tag or tags to assign to the resource.
     */
    public val tags: List<Tag>? = builder.tags
    /**
     * The ID of the application tenant.
     */
    public val tenantId: kotlin.String? = builder.tenantId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appfabric.model.CreateIngestionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIngestionRequest(")
        append("app=$app,")
        append("appBundleIdentifier=$appBundleIdentifier,")
        append("clientToken=$clientToken,")
        append("ingestionType=$ingestionType,")
        append("tags=$tags,")
        append("tenantId=$tenantId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = app?.hashCode() ?: 0
        result = 31 * result + (appBundleIdentifier?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (ingestionType?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tenantId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIngestionRequest

        if (app != other.app) return false
        if (appBundleIdentifier != other.appBundleIdentifier) return false
        if (clientToken != other.clientToken) return false
        if (ingestionType != other.ingestionType) return false
        if (tags != other.tags) return false
        if (tenantId != other.tenantId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appfabric.model.CreateIngestionRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The name of the application.
         *
         * Valid values are:
         * + `SLACK`
         * + `ASANA`
         * + `JIRA`
         * + `M365`
         * + `M365AUDITLOGS`
         * + `ZOOM`
         * + `ZENDESK`
         * + `OKTA`
         * + `GOOGLE`
         * + `DROPBOX`
         * + `SMARTSHEET`
         * + `CISCO`
         */
        public var app: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
         */
        public var appBundleIdentifier: kotlin.String? = null
        /**
         * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value](https://wikipedia.org/wiki/Universally_unique_identifier).
         *
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         *
         * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `IdempotentParameterMismatch` error.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The ingestion type.
         */
        public var ingestionType: aws.sdk.kotlin.services.appfabric.model.IngestionType? = null
        /**
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         */
        public var tags: List<Tag>? = null
        /**
         * The ID of the application tenant.
         */
        public var tenantId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appfabric.model.CreateIngestionRequest) : this() {
            this.app = x.app
            this.appBundleIdentifier = x.appBundleIdentifier
            this.clientToken = x.clientToken
            this.ingestionType = x.ingestionType
            this.tags = x.tags
            this.tenantId = x.tenantId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appfabric.model.CreateIngestionRequest = CreateIngestionRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
