// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains authorization request information, which is required for Amazon Web Services AppFabric to get the OAuth2 access token for an application.
 */
public class AuthRequest private constructor(builder: Builder) {
    /**
     * The authorization code returned by the application after permission is granted in the application OAuth page (after clicking on the AuthURL).
     */
    public val code: kotlin.String = requireNotNull(builder.code) { "A non-null value must be provided for code" }
    /**
     * The redirect URL that is specified in the AuthURL and the application client.
     */
    public val redirectUri: kotlin.String = requireNotNull(builder.redirectUri) { "A non-null value must be provided for redirectUri" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appfabric.model.AuthRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AuthRequest(")
        append("code=*** Sensitive Data Redacted ***,")
        append("redirectUri=$redirectUri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = code.hashCode()
        result = 31 * result + (redirectUri.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AuthRequest

        if (code != other.code) return false
        if (redirectUri != other.redirectUri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appfabric.model.AuthRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The authorization code returned by the application after permission is granted in the application OAuth page (after clicking on the AuthURL).
         */
        public var code: kotlin.String? = null
        /**
         * The redirect URL that is specified in the AuthURL and the application client.
         */
        public var redirectUri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appfabric.model.AuthRequest) : this() {
            this.code = x.code
            this.redirectUri = x.redirectUri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appfabric.model.AuthRequest = AuthRequest(this)

        internal fun correctErrors(): Builder {
            if (code == null) code = ""
            if (redirectUri == null) redirectUri = ""
            return this
        }
    }
}
