// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.serde

import aws.sdk.kotlin.services.appfabric.model.CreateIngestionDestinationRequest
import aws.sdk.kotlin.services.appfabric.model.DestinationConfiguration
import aws.sdk.kotlin.services.appfabric.model.ProcessingConfiguration
import aws.sdk.kotlin.services.appfabric.model.Tag
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateIngestionDestinationOperationSerializer: HttpSerialize<CreateIngestionDestinationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateIngestionDestinationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.appBundleIdentifier) { "appBundleIdentifier is bound to the URI and must not be null" }
            requireNotNull(input.ingestionIdentifier) { "ingestionIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("appbundles"))
                add(PercentEncoding.SmithyLabel.encode("${input.appBundleIdentifier}"))
                add(PercentEncoding.Path.encode("ingestions"))
                add(PercentEncoding.SmithyLabel.encode("${input.ingestionIdentifier}"))
                add(PercentEncoding.Path.encode("ingestiondestinations"))
            }
        }

        val payload = serializeCreateIngestionDestinationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateIngestionDestinationOperationBody(context: ExecutionContext, input: CreateIngestionDestinationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESTINATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("destinationConfiguration"))
    val PROCESSINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("processingConfiguration"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESTINATIONCONFIGURATION_DESCRIPTOR)
        field(PROCESSINGCONFIGURATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.destinationConfiguration?.let { field(DESTINATIONCONFIGURATION_DESCRIPTOR, it, ::serializeDestinationConfigurationDocument) }
        input.processingConfiguration?.let { field(PROCESSINGCONFIGURATION_DESCRIPTOR, it, ::serializeProcessingConfigurationDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
