// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.serde

import aws.sdk.kotlin.services.appfabric.model.AuthType
import aws.sdk.kotlin.services.appfabric.model.CreateAppAuthorizationRequest
import aws.sdk.kotlin.services.appfabric.model.Credential
import aws.sdk.kotlin.services.appfabric.model.Tag
import aws.sdk.kotlin.services.appfabric.model.Tenant
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateAppAuthorizationOperationSerializer: HttpSerialize<CreateAppAuthorizationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateAppAuthorizationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.appBundleIdentifier) { "appBundleIdentifier is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("appbundles"))
                add(PercentEncoding.SmithyLabel.encode("${input.appBundleIdentifier}"))
                add(PercentEncoding.Path.encode("appauthorizations"))
            }
        }

        val payload = serializeCreateAppAuthorizationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAppAuthorizationOperationBody(context: ExecutionContext, input: CreateAppAuthorizationRequest): ByteArray {
    val serializer = JsonSerializer()
    val APP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("app"))
    val AUTHTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authType"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CREDENTIAL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("credential"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tags"))
    val TENANT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tenant"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APP_DESCRIPTOR)
        field(AUTHTYPE_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CREDENTIAL_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TENANT_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.app?.let { field(APP_DESCRIPTOR, it) }
        input.authType?.let { field(AUTHTYPE_DESCRIPTOR, it.value) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.credential?.let { field(CREDENTIAL_DESCRIPTOR, it, ::serializeCredentialDocument) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.tenant?.let { field(TENANT_DESCRIPTOR, it, ::serializeTenantDocument) }
    }
    return serializer.toByteArray()
}
