// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.model



/**
 * Contains information about a user's access to an application.
 */
public class UserAccessResultItem private constructor(builder: Builder) {
    /**
     * The name of the application.
     */
    public val app: kotlin.String? = builder.app
    /**
     * The email address of the target user.
     */
    public val email: kotlin.String? = builder.email
    /**
     * The status of the user access result item.
     *
     * The following states are possible:
     * + `IN_PROGRESS`: The user access task is in progress.
     * + `COMPLETED`: The user access task completed successfully.
     * + `FAILED`: The user access task failed.
     * + `EXPIRED`: The user access task expired.
     */
    public val resultStatus: aws.sdk.kotlin.services.appfabric.model.ResultStatus? = builder.resultStatus
    /**
     * Contains information about an error returned from a user access task.
     */
    public val taskError: aws.sdk.kotlin.services.appfabric.model.TaskError? = builder.taskError
    /**
     * The unique ID of the task.
     */
    public val taskId: kotlin.String? = builder.taskId
    /**
     * The display name of the tenant.
     */
    public val tenantDisplayName: kotlin.String? = builder.tenantDisplayName
    /**
     * The ID of the application tenant.
     */
    public val tenantId: kotlin.String? = builder.tenantId
    /**
     * The first name of the user.
     */
    public val userFirstName: kotlin.String? = builder.userFirstName
    /**
     * The full name of the user.
     */
    public val userFullName: kotlin.String? = builder.userFullName
    /**
     * The unique ID of user.
     */
    public val userId: kotlin.String? = builder.userId
    /**
     * The last name of the user.
     */
    public val userLastName: kotlin.String? = builder.userLastName
    /**
     * The status of the user returned by the application.
     */
    public val userStatus: kotlin.String? = builder.userStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appfabric.model.UserAccessResultItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UserAccessResultItem(")
        append("app=$app,")
        append("email=*** Sensitive Data Redacted ***,")
        append("resultStatus=$resultStatus,")
        append("taskError=$taskError,")
        append("taskId=$taskId,")
        append("tenantDisplayName=$tenantDisplayName,")
        append("tenantId=$tenantId,")
        append("userFirstName=*** Sensitive Data Redacted ***,")
        append("userFullName=*** Sensitive Data Redacted ***,")
        append("userId=*** Sensitive Data Redacted ***,")
        append("userLastName=*** Sensitive Data Redacted ***,")
        append("userStatus=$userStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = app?.hashCode() ?: 0
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (resultStatus?.hashCode() ?: 0)
        result = 31 * result + (taskError?.hashCode() ?: 0)
        result = 31 * result + (taskId?.hashCode() ?: 0)
        result = 31 * result + (tenantDisplayName?.hashCode() ?: 0)
        result = 31 * result + (tenantId?.hashCode() ?: 0)
        result = 31 * result + (userFirstName?.hashCode() ?: 0)
        result = 31 * result + (userFullName?.hashCode() ?: 0)
        result = 31 * result + (userId?.hashCode() ?: 0)
        result = 31 * result + (userLastName?.hashCode() ?: 0)
        result = 31 * result + (userStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UserAccessResultItem

        if (app != other.app) return false
        if (email != other.email) return false
        if (resultStatus != other.resultStatus) return false
        if (taskError != other.taskError) return false
        if (taskId != other.taskId) return false
        if (tenantDisplayName != other.tenantDisplayName) return false
        if (tenantId != other.tenantId) return false
        if (userFirstName != other.userFirstName) return false
        if (userFullName != other.userFullName) return false
        if (userId != other.userId) return false
        if (userLastName != other.userLastName) return false
        if (userStatus != other.userStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appfabric.model.UserAccessResultItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the application.
         */
        public var app: kotlin.String? = null
        /**
         * The email address of the target user.
         */
        public var email: kotlin.String? = null
        /**
         * The status of the user access result item.
         *
         * The following states are possible:
         * + `IN_PROGRESS`: The user access task is in progress.
         * + `COMPLETED`: The user access task completed successfully.
         * + `FAILED`: The user access task failed.
         * + `EXPIRED`: The user access task expired.
         */
        public var resultStatus: aws.sdk.kotlin.services.appfabric.model.ResultStatus? = null
        /**
         * Contains information about an error returned from a user access task.
         */
        public var taskError: aws.sdk.kotlin.services.appfabric.model.TaskError? = null
        /**
         * The unique ID of the task.
         */
        public var taskId: kotlin.String? = null
        /**
         * The display name of the tenant.
         */
        public var tenantDisplayName: kotlin.String? = null
        /**
         * The ID of the application tenant.
         */
        public var tenantId: kotlin.String? = null
        /**
         * The first name of the user.
         */
        public var userFirstName: kotlin.String? = null
        /**
         * The full name of the user.
         */
        public var userFullName: kotlin.String? = null
        /**
         * The unique ID of user.
         */
        public var userId: kotlin.String? = null
        /**
         * The last name of the user.
         */
        public var userLastName: kotlin.String? = null
        /**
         * The status of the user returned by the application.
         */
        public var userStatus: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appfabric.model.UserAccessResultItem) : this() {
            this.app = x.app
            this.email = x.email
            this.resultStatus = x.resultStatus
            this.taskError = x.taskError
            this.taskId = x.taskId
            this.tenantDisplayName = x.tenantDisplayName
            this.tenantId = x.tenantId
            this.userFirstName = x.userFirstName
            this.userFullName = x.userFullName
            this.userId = x.userId
            this.userLastName = x.userLastName
            this.userStatus = x.userStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appfabric.model.UserAccessResultItem = UserAccessResultItem(this)

        /**
         * construct an [aws.sdk.kotlin.services.appfabric.model.TaskError] inside the given [block]
         */
        public fun taskError(block: aws.sdk.kotlin.services.appfabric.model.TaskError.Builder.() -> kotlin.Unit) {
            this.taskError = aws.sdk.kotlin.services.appfabric.model.TaskError.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
