// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.model



public class ListIngestionDestinationsRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     */
    public val appBundleIdentifier: kotlin.String? = builder.appBundleIdentifier
    /**
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
     */
    public val ingestionIdentifier: kotlin.String? = builder.ingestionIdentifier
    /**
     * The maximum number of results that are returned per call. You can use `nextToken` to obtain further pages of results.
     *
     * This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken error*.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appfabric.model.ListIngestionDestinationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListIngestionDestinationsRequest(")
        append("appBundleIdentifier=$appBundleIdentifier,")
        append("ingestionIdentifier=$ingestionIdentifier,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appBundleIdentifier?.hashCode() ?: 0
        result = 31 * result + (ingestionIdentifier?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListIngestionDestinationsRequest

        if (appBundleIdentifier != other.appBundleIdentifier) return false
        if (ingestionIdentifier != other.ingestionIdentifier) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appfabric.model.ListIngestionDestinationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
         */
        public var appBundleIdentifier: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
         */
        public var ingestionIdentifier: kotlin.String? = null
        /**
         * The maximum number of results that are returned per call. You can use `nextToken` to obtain further pages of results.
         *
         * This is only an upper limit. The actual number of results returned per call might be fewer than the specified maximum.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * If `nextToken` is returned, there are more results available. The value of `nextToken` is a unique pagination token for each page. Make the call again using the returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination token will return an *HTTP 400 InvalidToken error*.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appfabric.model.ListIngestionDestinationsRequest) : this() {
            this.appBundleIdentifier = x.appBundleIdentifier
            this.ingestionIdentifier = x.ingestionIdentifier
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appfabric.model.ListIngestionDestinationsRequest = ListIngestionDestinationsRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
