// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains information about an ingestion.
 */
public class Ingestion private constructor(builder: Builder) {
    /**
     * The name of the application.
     */
    public val app: kotlin.String = requireNotNull(builder.app) { "A non-null value must be provided for app" }
    /**
     * The Amazon Resource Name (ARN) of the app bundle for the ingestion.
     */
    public val appBundleArn: kotlin.String = requireNotNull(builder.appBundleArn) { "A non-null value must be provided for appBundleArn" }
    /**
     * The Amazon Resource Name (ARN) of the ingestion.
     */
    public val arn: kotlin.String = requireNotNull(builder.arn) { "A non-null value must be provided for arn" }
    /**
     * The timestamp of when the ingestion was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * The type of the ingestion.
     */
    public val ingestionType: aws.sdk.kotlin.services.appfabric.model.IngestionType = requireNotNull(builder.ingestionType) { "A non-null value must be provided for ingestionType" }
    /**
     * The status of the ingestion.
     */
    public val state: aws.sdk.kotlin.services.appfabric.model.IngestionState = requireNotNull(builder.state) { "A non-null value must be provided for state" }
    /**
     * The ID of the application tenant.
     */
    public val tenantId: kotlin.String = requireNotNull(builder.tenantId) { "A non-null value must be provided for tenantId" }
    /**
     * The timestamp of when the ingestion was last updated.
     */
    public val updatedAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updatedAt) { "A non-null value must be provided for updatedAt" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appfabric.model.Ingestion = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Ingestion(")
        append("app=$app,")
        append("appBundleArn=$appBundleArn,")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("ingestionType=$ingestionType,")
        append("state=$state,")
        append("tenantId=$tenantId,")
        append("updatedAt=$updatedAt")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = app.hashCode()
        result = 31 * result + (appBundleArn.hashCode())
        result = 31 * result + (arn.hashCode())
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (ingestionType.hashCode())
        result = 31 * result + (state.hashCode())
        result = 31 * result + (tenantId.hashCode())
        result = 31 * result + (updatedAt.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Ingestion

        if (app != other.app) return false
        if (appBundleArn != other.appBundleArn) return false
        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (ingestionType != other.ingestionType) return false
        if (state != other.state) return false
        if (tenantId != other.tenantId) return false
        if (updatedAt != other.updatedAt) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appfabric.model.Ingestion = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the application.
         */
        public var app: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the app bundle for the ingestion.
         */
        public var appBundleArn: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the ingestion.
         */
        public var arn: kotlin.String? = null
        /**
         * The timestamp of when the ingestion was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The type of the ingestion.
         */
        public var ingestionType: aws.sdk.kotlin.services.appfabric.model.IngestionType? = null
        /**
         * The status of the ingestion.
         */
        public var state: aws.sdk.kotlin.services.appfabric.model.IngestionState? = null
        /**
         * The ID of the application tenant.
         */
        public var tenantId: kotlin.String? = null
        /**
         * The timestamp of when the ingestion was last updated.
         */
        public var updatedAt: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appfabric.model.Ingestion) : this() {
            this.app = x.app
            this.appBundleArn = x.appBundleArn
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.ingestionType = x.ingestionType
            this.state = x.state
            this.tenantId = x.tenantId
            this.updatedAt = x.updatedAt
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appfabric.model.Ingestion = Ingestion(this)

        internal fun correctErrors(): Builder {
            if (app == null) app = ""
            if (appBundleArn == null) appBundleArn = ""
            if (arn == null) arn = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (ingestionType == null) ingestionType = IngestionType.SdkUnknown("no value provided")
            if (state == null) state = IngestionState.SdkUnknown("no value provided")
            if (tenantId == null) tenantId = ""
            if (updatedAt == null) updatedAt = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
