// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.appfabric.model



public class CreateIngestionDestinationRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
     */
    public val appBundleIdentifier: kotlin.String? = builder.appBundleIdentifier
    /**
     * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value](https://wikipedia.org/wiki/Universally_unique_identifier).
     *
     * If you don't provide this value, then Amazon Web Services generates a random one for you.
     *
     * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `IdempotentParameterMismatch` error.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Contains information about the destination of ingested data.
     */
    public val destinationConfiguration: aws.sdk.kotlin.services.appfabric.model.DestinationConfiguration? = builder.destinationConfiguration
    /**
     * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
     */
    public val ingestionIdentifier: kotlin.String? = builder.ingestionIdentifier
    /**
     * Contains information about how ingested data is processed.
     */
    public val processingConfiguration: aws.sdk.kotlin.services.appfabric.model.ProcessingConfiguration? = builder.processingConfiguration
    /**
     * A map of the key-value pairs of the tag or tags to assign to the resource.
     */
    public val tags: List<Tag>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.appfabric.model.CreateIngestionDestinationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateIngestionDestinationRequest(")
        append("appBundleIdentifier=$appBundleIdentifier,")
        append("clientToken=$clientToken,")
        append("destinationConfiguration=$destinationConfiguration,")
        append("ingestionIdentifier=$ingestionIdentifier,")
        append("processingConfiguration=$processingConfiguration,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appBundleIdentifier?.hashCode() ?: 0
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (destinationConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ingestionIdentifier?.hashCode() ?: 0)
        result = 31 * result + (processingConfiguration?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateIngestionDestinationRequest

        if (appBundleIdentifier != other.appBundleIdentifier) return false
        if (clientToken != other.clientToken) return false
        if (destinationConfiguration != other.destinationConfiguration) return false
        if (ingestionIdentifier != other.ingestionIdentifier) return false
        if (processingConfiguration != other.processingConfiguration) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.appfabric.model.CreateIngestionDestinationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the app bundle to use for the request.
         */
        public var appBundleIdentifier: kotlin.String? = null
        /**
         * Specifies a unique, case-sensitive identifier that you provide to ensure the idempotency of the request. This lets you safely retry the request without accidentally performing the same operation a second time. Passing the same value to a later call to an operation requires that you also pass the same value for all other parameters. We recommend that you use a [UUID type of value](https://wikipedia.org/wiki/Universally_unique_identifier).
         *
         * If you don't provide this value, then Amazon Web Services generates a random one for you.
         *
         * If you retry the operation with the same `ClientToken`, but with different parameters, the retry fails with an `IdempotentParameterMismatch` error.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Contains information about the destination of ingested data.
         */
        public var destinationConfiguration: aws.sdk.kotlin.services.appfabric.model.DestinationConfiguration? = null
        /**
         * The Amazon Resource Name (ARN) or Universal Unique Identifier (UUID) of the ingestion to use for the request.
         */
        public var ingestionIdentifier: kotlin.String? = null
        /**
         * Contains information about how ingested data is processed.
         */
        public var processingConfiguration: aws.sdk.kotlin.services.appfabric.model.ProcessingConfiguration? = null
        /**
         * A map of the key-value pairs of the tag or tags to assign to the resource.
         */
        public var tags: List<Tag>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.appfabric.model.CreateIngestionDestinationRequest) : this() {
            this.appBundleIdentifier = x.appBundleIdentifier
            this.clientToken = x.clientToken
            this.destinationConfiguration = x.destinationConfiguration
            this.ingestionIdentifier = x.ingestionIdentifier
            this.processingConfiguration = x.processingConfiguration
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.appfabric.model.CreateIngestionDestinationRequest = CreateIngestionDestinationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
