// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model



/**
 * Creates a new Api resource to represent an API.
 */
public class CreateApiRequest private constructor(builder: Builder) {
    /**
     * An API key selection expression. Supported only for WebSocket APIs. See [API Key Selection Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
     */
    public val apiKeySelectionExpression: kotlin.String? = builder.apiKeySelectionExpression
    /**
     * A CORS configuration. Supported only for HTTP APIs. See [Configuring CORS](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html) for more information.
     */
    public val corsConfiguration: aws.sdk.kotlin.services.apigatewayv2.model.Cors? = builder.corsConfiguration
    /**
     * This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user&#47;*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.
     */
    public val credentialsArn: kotlin.String? = builder.credentialsArn
    /**
     * The description of the API.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
     */
    public val disableExecuteApiEndpoint: kotlin.Boolean? = builder.disableExecuteApiEndpoint
    /**
     * Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
     */
    public val disableSchemaValidation: kotlin.Boolean? = builder.disableSchemaValidation
    /**
     * The name of the API.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The API protocol.
     */
    public val protocolType: aws.sdk.kotlin.services.apigatewayv2.model.ProtocolType? = builder.protocolType
    /**
     * This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.
     */
    public val routeKey: kotlin.String? = builder.routeKey
    /**
     * The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
     */
    public val routeSelectionExpression: kotlin.String? = builder.routeSelectionExpression
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.
     */
    public val target: kotlin.String? = builder.target
    /**
     * A version identifier for the API.
     */
    public val version: kotlin.String? = builder.version

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.CreateApiRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApiRequest(")
        append("apiKeySelectionExpression=$apiKeySelectionExpression,")
        append("corsConfiguration=$corsConfiguration,")
        append("credentialsArn=$credentialsArn,")
        append("description=$description,")
        append("disableExecuteApiEndpoint=$disableExecuteApiEndpoint,")
        append("disableSchemaValidation=$disableSchemaValidation,")
        append("name=$name,")
        append("protocolType=$protocolType,")
        append("routeKey=$routeKey,")
        append("routeSelectionExpression=$routeSelectionExpression,")
        append("tags=$tags,")
        append("target=$target,")
        append("version=$version")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKeySelectionExpression?.hashCode() ?: 0
        result = 31 * result + (corsConfiguration?.hashCode() ?: 0)
        result = 31 * result + (credentialsArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (disableExecuteApiEndpoint?.hashCode() ?: 0)
        result = 31 * result + (disableSchemaValidation?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (protocolType?.hashCode() ?: 0)
        result = 31 * result + (routeKey?.hashCode() ?: 0)
        result = 31 * result + (routeSelectionExpression?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        result = 31 * result + (version?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApiRequest

        if (apiKeySelectionExpression != other.apiKeySelectionExpression) return false
        if (corsConfiguration != other.corsConfiguration) return false
        if (credentialsArn != other.credentialsArn) return false
        if (description != other.description) return false
        if (disableExecuteApiEndpoint != other.disableExecuteApiEndpoint) return false
        if (disableSchemaValidation != other.disableSchemaValidation) return false
        if (name != other.name) return false
        if (protocolType != other.protocolType) return false
        if (routeKey != other.routeKey) return false
        if (routeSelectionExpression != other.routeSelectionExpression) return false
        if (tags != other.tags) return false
        if (target != other.target) return false
        if (version != other.version) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.CreateApiRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An API key selection expression. Supported only for WebSocket APIs. See [API Key Selection Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
         */
        public var apiKeySelectionExpression: kotlin.String? = null
        /**
         * A CORS configuration. Supported only for HTTP APIs. See [Configuring CORS](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html) for more information.
         */
        public var corsConfiguration: aws.sdk.kotlin.services.apigatewayv2.model.Cors? = null
        /**
         * This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user&#47;*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs.
         */
        public var credentialsArn: kotlin.String? = null
        /**
         * The description of the API.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint.
         */
        public var disableExecuteApiEndpoint: kotlin.Boolean? = null
        /**
         * Avoid validating models when creating a deployment. Supported only for WebSocket APIs.
         */
        public var disableSchemaValidation: kotlin.Boolean? = null
        /**
         * The name of the API.
         */
        public var name: kotlin.String? = null
        /**
         * The API protocol.
         */
        public var protocolType: aws.sdk.kotlin.services.apigatewayv2.model.ProtocolType? = null
        /**
         * This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs.
         */
        public var routeKey: kotlin.String? = null
        /**
         * The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs.
         */
        public var routeSelectionExpression: kotlin.String? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs.
         */
        public var target: kotlin.String? = null
        /**
         * A version identifier for the API.
         */
        public var version: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.CreateApiRequest) : this() {
            this.apiKeySelectionExpression = x.apiKeySelectionExpression
            this.corsConfiguration = x.corsConfiguration
            this.credentialsArn = x.credentialsArn
            this.description = x.description
            this.disableExecuteApiEndpoint = x.disableExecuteApiEndpoint
            this.disableSchemaValidation = x.disableSchemaValidation
            this.name = x.name
            this.protocolType = x.protocolType
            this.routeKey = x.routeKey
            this.routeSelectionExpression = x.routeSelectionExpression
            this.tags = x.tags
            this.target = x.target
            this.version = x.version
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.CreateApiRequest = CreateApiRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigatewayv2.model.Cors] inside the given [block]
         */
        public fun corsConfiguration(block: aws.sdk.kotlin.services.apigatewayv2.model.Cors.Builder.() -> kotlin.Unit) {
            this.corsConfiguration = aws.sdk.kotlin.services.apigatewayv2.model.Cors.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
