// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.ApiGatewayV2Exception
import aws.sdk.kotlin.services.apigatewayv2.model.UpdateApiMappingResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateApiMappingOperationDeserializer: HttpDeserialize<UpdateApiMappingResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateApiMappingResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateApiMappingError(context, call)
        }
        val builder = UpdateApiMappingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateApiMappingOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateApiMappingError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayV2Exception("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayV2Exception(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateApiMappingOperationBody(builder: UpdateApiMappingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APIID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiId"))
    val APIMAPPINGID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiMappingId"))
    val APIMAPPINGKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("apiMappingKey"))
    val STAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIID_DESCRIPTOR)
        field(APIMAPPINGID_DESCRIPTOR)
        field(APIMAPPINGKEY_DESCRIPTOR)
        field(STAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APIID_DESCRIPTOR.index -> builder.apiId = deserializeString()
                APIMAPPINGID_DESCRIPTOR.index -> builder.apiMappingId = deserializeString()
                APIMAPPINGKEY_DESCRIPTOR.index -> builder.apiMappingKey = deserializeString()
                STAGE_DESCRIPTOR.index -> builder.stage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
