// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.CreateRouteResponseRequest
import aws.sdk.kotlin.services.apigatewayv2.model.ParameterConstraints
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRouteResponseOperationSerializer: HttpSerialize<CreateRouteResponseRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateRouteResponseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "v2",
                "apis",
                "${input.apiId}".encodeLabel(),
                "routes",
                "${input.routeId}".encodeLabel(),
                "routeresponses",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateRouteResponseOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateRouteResponseOperationBody(context: ExecutionContext, input: CreateRouteResponseRequest): ByteArray {
    val serializer = JsonSerializer()
    val MODELSELECTIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("modelSelectionExpression"))
    val RESPONSEMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseModels"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val ROUTERESPONSEKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("routeResponseKey"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(MODELSELECTIONEXPRESSION_DESCRIPTOR)
        field(RESPONSEMODELS_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
        field(ROUTERESPONSEKEY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.modelSelectionExpression?.let { field(MODELSELECTIONEXPRESSION_DESCRIPTOR, it) }
        if (input.responseModels != null) {
            mapField(RESPONSEMODELS_DESCRIPTOR) {
                input.responseModels.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.responseParameters != null) {
            mapField(RESPONSEPARAMETERS_DESCRIPTOR) {
                input.responseParameters.forEach { (key, value) -> entry(key, asSdkSerializable(value, ::serializeParameterConstraintsDocument)) }
            }
        }
        input.routeResponseKey?.let { field(ROUTERESPONSEKEY_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
