// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.serde

import aws.sdk.kotlin.services.apigatewayv2.model.AuthorizerType
import aws.sdk.kotlin.services.apigatewayv2.model.CreateAuthorizerRequest
import aws.sdk.kotlin.services.apigatewayv2.model.JwtConfiguration
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateAuthorizerOperationSerializer: HttpSerialize<CreateAuthorizerRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateAuthorizerRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "v2",
                "apis",
                "${input.apiId}".encodeLabel(),
                "authorizers",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeCreateAuthorizerOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateAuthorizerOperationBody(context: ExecutionContext, input: CreateAuthorizerRequest): ByteArray {
    val serializer = JsonSerializer()
    val AUTHORIZERCREDENTIALSARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerCredentialsArn"))
    val AUTHORIZERPAYLOADFORMATVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerPayloadFormatVersion"))
    val AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("authorizerResultTtlInSeconds"))
    val AUTHORIZERTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("authorizerType"))
    val AUTHORIZERURI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerUri"))
    val ENABLESIMPLERESPONSES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableSimpleResponses"))
    val IDENTITYSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("identitySource"))
    val IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("identityValidationExpression"))
    val JWTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("jwtConfiguration"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHORIZERCREDENTIALSARN_DESCRIPTOR)
        field(AUTHORIZERPAYLOADFORMATVERSION_DESCRIPTOR)
        field(AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR)
        field(AUTHORIZERTYPE_DESCRIPTOR)
        field(AUTHORIZERURI_DESCRIPTOR)
        field(ENABLESIMPLERESPONSES_DESCRIPTOR)
        field(IDENTITYSOURCE_DESCRIPTOR)
        field(IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR)
        field(JWTCONFIGURATION_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.authorizerCredentialsArn?.let { field(AUTHORIZERCREDENTIALSARN_DESCRIPTOR, it) }
        input.authorizerPayloadFormatVersion?.let { field(AUTHORIZERPAYLOADFORMATVERSION_DESCRIPTOR, it) }
        input.authorizerResultTtlInSeconds?.let { field(AUTHORIZERRESULTTTLINSECONDS_DESCRIPTOR, it) }
        input.authorizerType?.let { field(AUTHORIZERTYPE_DESCRIPTOR, it.value) }
        input.authorizerUri?.let { field(AUTHORIZERURI_DESCRIPTOR, it) }
        input.enableSimpleResponses?.let { field(ENABLESIMPLERESPONSES_DESCRIPTOR, it) }
        if (input.identitySource != null) {
            listField(IDENTITYSOURCE_DESCRIPTOR) {
                for (el0 in input.identitySource) {
                    serializeString(el0)
                }
            }
        }
        input.identityValidationExpression?.let { field(IDENTITYVALIDATIONEXPRESSION_DESCRIPTOR, it) }
        input.jwtConfiguration?.let { field(JWTCONFIGURATION_DESCRIPTOR, it, ::serializeJwtConfigurationDocument) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
