// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigatewayv2.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a VPC link.
 */
public class VpcLink private constructor(builder: Builder) {
    /**
     * The timestamp when the VPC link was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * The name of the VPC link.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of security group IDs for the VPC link.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of subnet IDs to include in the VPC link.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * Tags for the VPC link.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The ID of the VPC link.
     */
    public val vpcLinkId: kotlin.String? = builder.vpcLinkId
    /**
     * The status of the VPC link.
     */
    public val vpcLinkStatus: aws.sdk.kotlin.services.apigatewayv2.model.VpcLinkStatus? = builder.vpcLinkStatus
    /**
     * A message summarizing the cause of the status of the VPC link.
     */
    public val vpcLinkStatusMessage: kotlin.String? = builder.vpcLinkStatusMessage
    /**
     * The version of the VPC link.
     */
    public val vpcLinkVersion: aws.sdk.kotlin.services.apigatewayv2.model.VpcLinkVersion? = builder.vpcLinkVersion

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigatewayv2.model.VpcLink = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcLink(")
        append("createdDate=$createdDate,")
        append("name=$name,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("tags=$tags,")
        append("vpcLinkId=$vpcLinkId,")
        append("vpcLinkStatus=$vpcLinkStatus,")
        append("vpcLinkStatusMessage=$vpcLinkStatusMessage,")
        append("vpcLinkVersion=$vpcLinkVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcLinkId?.hashCode() ?: 0)
        result = 31 * result + (vpcLinkStatus?.hashCode() ?: 0)
        result = 31 * result + (vpcLinkStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (vpcLinkVersion?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcLink

        if (createdDate != other.createdDate) return false
        if (name != other.name) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (tags != other.tags) return false
        if (vpcLinkId != other.vpcLinkId) return false
        if (vpcLinkStatus != other.vpcLinkStatus) return false
        if (vpcLinkStatusMessage != other.vpcLinkStatusMessage) return false
        if (vpcLinkVersion != other.vpcLinkVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigatewayv2.model.VpcLink = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp when the VPC link was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the VPC link.
         */
        public var name: kotlin.String? = null
        /**
         * A list of security group IDs for the VPC link.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A list of subnet IDs to include in the VPC link.
         */
        public var subnetIds: List<String>? = null
        /**
         * Tags for the VPC link.
         */
        public var tags: Map<String, String>? = null
        /**
         * The ID of the VPC link.
         */
        public var vpcLinkId: kotlin.String? = null
        /**
         * The status of the VPC link.
         */
        public var vpcLinkStatus: aws.sdk.kotlin.services.apigatewayv2.model.VpcLinkStatus? = null
        /**
         * A message summarizing the cause of the status of the VPC link.
         */
        public var vpcLinkStatusMessage: kotlin.String? = null
        /**
         * The version of the VPC link.
         */
        public var vpcLinkVersion: aws.sdk.kotlin.services.apigatewayv2.model.VpcLinkVersion? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigatewayv2.model.VpcLink) : this() {
            this.createdDate = x.createdDate
            this.name = x.name
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.tags = x.tags
            this.vpcLinkId = x.vpcLinkId
            this.vpcLinkStatus = x.vpcLinkStatus
            this.vpcLinkStatusMessage = x.vpcLinkStatusMessage
            this.vpcLinkVersion = x.vpcLinkVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigatewayv2.model.VpcLink = VpcLink(this)

        internal fun correctErrors(): Builder {
            if (name == null) name = ""
            if (securityGroupIds == null) securityGroupIds = emptyList()
            if (subnetIds == null) subnetIds = emptyList()
            if (vpcLinkId == null) vpcLinkId = ""
            return this
        }
    }
}
